/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.tiles.TileEntityLightningCell;

public class LEMultiblockCapability
extends MultiblockCapability<Double> {
    public static final LEMultiblockCapability CAP = new LEMultiblockCapability();

    private LEMultiblockCapability() {
        super("lightningcraft_le", new Color(14995466).getRGB());
    }

    @Override
    public Double defaultContent() {
        return 100.0;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof TileEntityLightningCell;
    }

    @Override
    public Double copyInner(Double content) {
        return content;
    }

    @Override
    public Double copyInnerByModifier(Double content, ContentModifier modifiers) {
        return modifiers.apply(content);
    }

    @Override
    public CapabilityProxy<? extends Double> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new LECapabilityProxy(this, tileEntity);
    }

    @Override
    public ContentWidget<? super Double> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("LE", this.color)).setUnit("LE");
    }

    @Override
    public BlockInfo[] getCandidates() {
        return (BlockInfo[])LCBlocks.lightningCell.func_176194_O().func_177619_a().stream().map(BlockInfo::new).toArray(BlockInfo[]::new);
    }

    public Double deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return jsonElement.getAsDouble();
    }

    public JsonElement serialize(Double aDouble, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)aDouble);
    }

    public static class LECapabilityProxy
    extends CapabilityProxy<Double> {
        double storedPower;

        public LECapabilityProxy(MultiblockCapability<? super Double> capability, TileEntity tileEntity) {
            super(capability, tileEntity);
        }

        @Override
        protected List<Double> handleRecipeInner(IO io, Recipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            TileEntityLightningCell tile = (TileEntityLightningCell)this.getTileEntity();
            if (tile == null) {
                return left;
            }
            double sum = left.stream().reduce(0.0, Double::sum);
            if (io == IO.IN) {
                double in = Math.min(tile.storedPower, sum);
                if (!simulate) {
                    tile.storedPower -= in;
                }
                sum -= in;
            } else if (io == IO.OUT) {
                double out = Math.min(tile.maxPower - tile.storedPower, sum);
                if (!simulate) {
                    tile.storedPower += out;
                }
                sum -= out;
            }
            return sum <= 0.0 ? null : Collections.singletonList(sum);
        }

        @Override
        protected boolean hasInnerChanged() {
            TileEntityLightningCell tile = (TileEntityLightningCell)this.getTileEntity();
            if (tile == null || tile.storedPower == this.storedPower) {
                return false;
            }
            this.storedPower = tile.storedPower;
            return true;
        }
    }
}

