/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.ItemsIngredient;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.common.capability.trait.ItemCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.ItemsContentWidget;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemMultiblockCapability
extends MultiblockCapability<ItemsIngredient> {
    public static final ItemMultiblockCapability CAP = new ItemMultiblockCapability();

    private ItemMultiblockCapability() {
        super("item", new Color(14246150).getRGB(), new ItemJeiAdapter());
    }

    @Override
    public ItemsIngredient defaultContent() {
        return new ItemsIngredient(1, Items.field_151042_j.func_190903_i());
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, tileEntity).isEmpty();
    }

    @Override
    public ItemsIngredient copyInner(ItemsIngredient content) {
        return content.copy();
    }

    @Override
    public ItemsIngredient copyInnerByModifier(ItemsIngredient content, ContentModifier modifier) {
        ItemsIngredient copy = content.copy();
        copy.setAmount((int)modifier.apply(content.getAmount()));
        return copy;
    }

    public ItemCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new ItemCapabilityProxy(tileEntity);
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new ItemCapabilityTrait();
    }

    @Override
    public ContentWidget<? super ItemsIngredient> createContentWidget() {
        return new ItemsContentWidget();
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(Blocks.field_150486_ae.func_176223_P()), new BlockInfo(Blocks.field_190977_dl.func_176223_P(), Blocks.field_190977_dl.createTileEntity(null, Blocks.field_190977_dl.func_176223_P()), new ItemStack(Blocks.field_190977_dl))};
    }

    public ItemsIngredient deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("ore")) {
            return new ItemsIngredient(jsonObject.get("amount").getAsInt(), jsonObject.get("ore").getAsString());
        }
        return new ItemsIngredient(jsonObject.get("amount").getAsInt(), (ItemStack[])Multiblocked.GSON.fromJson(jsonObject.get("matches"), ItemStack[].class));
    }

    public JsonElement serialize(ItemsIngredient itemsIngredient, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("amount", (Number)itemsIngredient.getAmount());
        if (itemsIngredient.isOre()) {
            jsonObject.addProperty("ore", itemsIngredient.getOreDict());
        } else {
            jsonObject.add("matches", Multiblocked.GSON.toJsonTree((Object)itemsIngredient.field_193371_b));
        }
        return jsonObject;
    }

    public static class ItemJeiAdapter
    implements IJeiIngredientAdapter<ItemsIngredient, ItemStack> {
        @Override
        public Class<ItemsIngredient> getInternalIngredientType() {
            return ItemsIngredient.class;
        }

        @Override
        public IIngredientType<ItemStack> getJeiIngredientType() {
            return VanillaTypes.ITEM;
        }

        @Override
        public Stream<ItemStack> apply(ItemsIngredient itemsIngredient) {
            return Arrays.stream(itemsIngredient.func_193365_a());
        }
    }

    public static class ItemCapabilityProxy
    extends CapCapabilityProxy<IItemHandler, ItemsIngredient> {
        ItemStack[] lastStacks = new ItemStack[0];
        int[] limits = new int[0];

        public ItemCapabilityProxy(TileEntity tileEntity) {
            super(MbdCapabilities.ITEM, tileEntity, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }

        @Override
        protected List<ItemsIngredient> handleRecipeInner(IO io, Recipe recipe, List<ItemsIngredient> left, @Nullable String slotName, boolean simulate) {
            block7: {
                Iterator<ItemsIngredient> iterator;
                IItemHandler capability;
                block6: {
                    capability = (IItemHandler)this.getCapability(slotName);
                    if (capability == null) {
                        return left;
                    }
                    iterator = left.iterator();
                    if (io != IO.IN) break block6;
                    block0: while (iterator.hasNext()) {
                        ItemsIngredient ingredient = iterator.next();
                        for (int i = 0; i < capability.getSlots(); ++i) {
                            ItemStack itemStack = capability.getStackInSlot(i);
                            if (!ingredient.apply(itemStack)) continue;
                            ItemStack extracted = capability.extractItem(i, ingredient.getAmount(), simulate);
                            ingredient.setAmount(ingredient.getAmount() - extracted.func_190916_E());
                            if (ingredient.getAmount() > 0) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    break block7;
                }
                if (io != IO.OUT) break block7;
                while (iterator.hasNext()) {
                    ItemsIngredient ingredient = iterator.next();
                    ItemStack output = ingredient.getOutputStack();
                    for (int i = 0; i < capability.getSlots() && !(output = capability.insertItem(i, output.func_77946_l(), simulate)).func_190926_b(); ++i) {
                    }
                    if (output.func_190926_b()) {
                        iterator.remove();
                        continue;
                    }
                    ingredient.setAmount(output.func_190916_E());
                }
            }
            return left.isEmpty() ? null : left;
        }

        @Override
        protected boolean hasInnerChanged() {
            int i;
            IItemHandler capability = (IItemHandler)this.getCapability(null);
            if (capability == null) {
                return false;
            }
            boolean same = true;
            if (this.lastStacks.length == capability.getSlots()) {
                for (i = 0; i < capability.getSlots(); ++i) {
                    ItemStack content = capability.getStackInSlot(i);
                    ItemStack lastContent = this.lastStacks[i];
                    if (lastContent == null) {
                        same = false;
                    } else if (!(lastContent.func_190926_b() && content.func_190926_b() || content.func_77969_a(lastContent))) {
                        same = false;
                    } else {
                        int lastCap;
                        int cap = capability.getSlotLimit(i);
                        if (cap == (lastCap = this.limits[i])) continue;
                        same = false;
                    }
                    break;
                }
            } else {
                same = false;
            }
            if (same) {
                return false;
            }
            this.lastStacks = new ItemStack[capability.getSlots()];
            this.limits = new int[capability.getSlots()];
            for (i = 0; i < capability.getSlots(); ++i) {
                this.lastStacks[i] = capability.getStackInSlot(i).func_77946_l();
                this.limits[i] = capability.getSlotLimit(i);
            }
            return true;
        }
    }
}

