/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.trait.ImpetusCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;

public class ImpetusThaumicAugmentationCapability
extends MultiblockCapability<Long> {
    public static final ImpetusThaumicAugmentationCapability CAP = new ImpetusThaumicAugmentationCapability();

    public ImpetusThaumicAugmentationCapability() {
        super("ta_impetus", new Color(0x805080).getRGB());
    }

    @Override
    public Long defaultContent() {
        return 5L;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, tileEntity).isEmpty();
    }

    @Override
    public Long copyInner(Long content) {
        return content;
    }

    @Override
    public Long copyInnerByModifier(Long content, ContentModifier modifier) {
        return (long)modifier.apply(content.longValue());
    }

    @Override
    public CapabilityProxy<? extends Long> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new ImpetusCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Long> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("IM", this.color)).setUnit("Impetus");
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{new BlockInfo(TABlocks.IMPETUS_MATRIX)};
    }

    public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsLong();
    }

    public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new ImpetusCapabilityTrait();
    }

    public static class ImpetusCapabilityProxy
    extends CapCapabilityProxy<IImpetusStorage, Long> {
        long stored = -1L;
        boolean canReceive = false;
        boolean canExtract = false;

        public ImpetusCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, CapabilityImpetusStorage.IMPETUS_STORAGE);
        }

        @Override
        protected List<Long> handleRecipeInner(IO io, Recipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
            IImpetusStorage capability = (IImpetusStorage)this.getCapability(slotName);
            if (capability == null) {
                return left;
            }
            long sum = left.stream().reduce(0L, Long::sum);
            if (io == IO.IN) {
                sum -= capability.extractEnergy(sum, simulate);
            } else if (io == IO.OUT) {
                sum -= capability.receiveEnergy(sum, simulate);
            }
            return sum > 0L ? Collections.singletonList(sum) : null;
        }

        @Override
        protected boolean hasInnerChanged() {
            IImpetusStorage capability = (IImpetusStorage)this.getCapability(null);
            if (capability == null) {
                return false;
            }
            if (capability.getEnergyStored() == this.stored && capability.canExtract() == this.canExtract && capability.canReceive() == this.canReceive) {
                return false;
            }
            this.stored = capability.getEnergyStored();
            this.canExtract = capability.canExtract();
            this.canReceive = capability.canReceive();
            return true;
        }
    }
}

