/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.IHotAir;
import lykrast.prodigytech.common.init.ModBlocks;
import net.minecraft.tileentity.TileEntity;

public class HotAirProdigyCapability
extends MultiblockCapability<Integer> {
    public static final HotAirProdigyCapability CAP = new HotAirProdigyCapability();

    private HotAirProdigyCapability() {
        super("prodigy_hotair", new Color(14229254).getRGB());
    }

    @Override
    public Integer defaultContent() {
        return 0;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(CapabilityHotAir.HOT_AIR, tileEntity).isEmpty();
    }

    @Override
    public Integer copyInner(Integer content) {
        return content;
    }

    @Override
    public Integer copyInnerByModifier(Integer content, ContentModifier modifier) {
        return (int)modifier.apply(content.intValue());
    }

    public HotAirProdigyCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new HotAirProdigyCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Integer> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("HA", this.color)).setUnit("\u00c2\u00b0C");
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(ModBlocks.aeroheaterMagmatic.func_176223_P()), BlockInfo.fromBlockState(ModBlocks.aeroheaterEnergion.func_176223_P()), BlockInfo.fromBlockState(ModBlocks.aeroheaterSolid.func_176223_P()), BlockInfo.fromBlockState(ModBlocks.aeroheaterTartaric.func_176223_P()), BlockInfo.fromBlockState(ModBlocks.aeroheaterCapacitor.func_176223_P())};
    }

    public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsInt();
    }

    public JsonElement serialize(Integer aInteger, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)aInteger);
    }

    public static class HotAirProdigyCapabilityProxy
    extends CapCapabilityProxy<IHotAir, Integer> {
        Integer lastTemp = Integer.MIN_VALUE;

        public HotAirProdigyCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, CapabilityHotAir.HOT_AIR);
        }

        @Override
        protected List<Integer> handleRecipeInner(IO io, Recipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            IHotAir capability = (IHotAir)this.getCapability(slotName);
            if (capability == null || capability.getOutAirTemperature() < left.get(0)) {
                return left;
            }
            return null;
        }

        @Override
        protected boolean hasInnerChanged() {
            IHotAir capability = (IHotAir)this.getCapability(null);
            if (capability == null || capability.getOutAirTemperature() <= 0) {
                return false;
            }
            if (this.lastTemp.intValue() == capability.getOutAirTemperature()) {
                return false;
            }
            this.lastTemp = capability.getOutAirTemperature();
            return true;
        }
    }
}

