/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IHeatTransfer;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.tileentity.TileEntity;

public class HeatMekanismCapability
extends MultiblockCapability<Double> {
    public static final HeatMekanismCapability CAP = new HeatMekanismCapability();

    private HeatMekanismCapability() {
        super("mek_heat", new Color(14222989).getRGB());
    }

    @Override
    public Double defaultContent() {
        return 100.0;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(Capabilities.HEAT_TRANSFER_CAPABILITY, tileEntity).isEmpty();
    }

    @Override
    public Double copyInner(Double content) {
        return content;
    }

    @Override
    public Double copyInnerByModifier(Double content, ContentModifier modifier) {
        return modifier.apply(content);
    }

    public HeatMekanismCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new HeatMekanismCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Double> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("HE", this.color)).setUnit("Heat");
    }

    @Override
    public BlockInfo[] getCandidates() {
        BlockStateMachine.MachineType[] machineTypes = new BlockStateMachine.MachineType[]{BlockStateMachine.MachineType.FUELWOOD_HEATER, BlockStateMachine.MachineType.RESISTIVE_HEATER};
        return (BlockInfo[])Arrays.stream(machineTypes).map(type -> new BlockInfo(type.typeBlock.getBlock().func_176203_a(type.meta), type.create(), type.getStack())).toArray(BlockInfo[]::new);
    }

    public Double deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return jsonElement.getAsDouble();
    }

    public JsonElement serialize(Double aDouble, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)aDouble);
    }

    public static class HeatMekanismCapabilityProxy
    extends CapCapabilityProxy<IHeatTransfer, Double> {
        double lastTemp = Double.MIN_VALUE;

        public HeatMekanismCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY);
        }

        @Override
        protected List<Double> handleRecipeInner(IO io, Recipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            IHeatTransfer capability = (IHeatTransfer)this.getCapability(slotName);
            if (capability == null || capability.getTemp() <= 0.0) {
                return left;
            }
            double sum = left.stream().reduce(0.0, Double::sum);
            if (io == IO.IN) {
                if (!simulate) {
                    capability.transferHeatTo(-sum);
                }
            } else if (io == IO.OUT && !simulate) {
                capability.transferHeatTo(sum);
            }
            return null;
        }

        @Override
        protected boolean hasInnerChanged() {
            IHeatTransfer capability = (IHeatTransfer)this.getCapability(null);
            if (capability == null || capability.getTemp() <= 0.0) {
                return false;
            }
            if (this.lastTemp == capability.getTemp()) {
                return false;
            }
            this.lastTemp = capability.getTemp();
            return true;
        }
    }
}

