/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.GasStackWidget;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismBlocks;
import mekanism.common.capabilities.Capabilities;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class GasMekanismCapability
extends MultiblockCapability<GasStack> {
    public static final GasMekanismCapability CAP = new GasMekanismCapability();

    private GasMekanismCapability() {
        super("mek_gas", new Color(8753310).getRGB(), new GasJeiAdapter());
    }

    @Override
    public GasStack defaultContent() {
        return new GasStack(GasRegistry.getGas((int)0), 1000);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, tileEntity).isEmpty();
    }

    @Override
    public GasStack copyInner(GasStack content) {
        return content.copy();
    }

    @Override
    public GasStack copyInnerByModifier(GasStack content, ContentModifier modifier) {
        GasStack copy = content.copy();
        copy.amount = (int)modifier.apply(content.amount);
        return copy;
    }

    public GasMekanismCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new GasMekanismCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super GasStack> createContentWidget() {
        return new GasStackWidget();
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(MekanismBlocks.GasTank.func_176223_P())};
    }

    public GasStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return new GasStack(GasRegistry.getGas((String)jsonElement.getAsJsonObject().get("gas").getAsString()), jsonElement.getAsJsonObject().get("amount").getAsInt());
    }

    public JsonElement serialize(GasStack gasStack, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("gas", gasStack.getGas().getName());
        jsonObj.addProperty("amount", (Number)gasStack.amount);
        return jsonObj;
    }

    public static class GasJeiAdapter
    implements IJeiIngredientAdapter<GasStack, GasStack> {
        @Override
        public Class<GasStack> getInternalIngredientType() {
            return GasStack.class;
        }

        @Override
        public IIngredientType<GasStack> getJeiIngredientType() {
            return MekanismJEI.TYPE_GAS;
        }

        @Override
        public Stream<GasStack> apply(GasStack gasStack) {
            return Stream.of(gasStack);
        }
    }

    public static class GasMekanismCapabilityProxy
    extends CapCapabilityProxy<IGasHandler, GasStack> {
        GasStack[] lastStacks = new GasStack[0];
        int[] lastStoreds = new int[0];
        int[] lastMaxs = new int[0];

        public GasMekanismCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, Capabilities.GAS_HANDLER_CAPABILITY);
        }

        @Override
        protected List<GasStack> handleRecipeInner(IO io, Recipe recipe, List<GasStack> left, @Nullable String slotName, boolean simulate) {
            block8: {
                Iterator<GasStack> iterator;
                IGasHandler capability;
                block7: {
                    capability = (IGasHandler)this.getCapability(slotName);
                    if (capability == null) {
                        return left;
                    }
                    iterator = left.iterator();
                    if (io != IO.IN) break block7;
                    while (iterator.hasNext()) {
                        GasStack gasStack = iterator.next();
                        for (EnumFacing facing : EnumFacing.values()) {
                            if (capability.canDrawGas(facing, gasStack.getGas())) {
                                GasStack drain = capability.drawGas(facing, gasStack.amount, !simulate);
                                if (drain == null) continue;
                                gasStack.amount -= drain.amount;
                            }
                            if (gasStack.amount <= 0) break;
                        }
                        if (gasStack.amount > 0) continue;
                        iterator.remove();
                    }
                    break block8;
                }
                if (io != IO.OUT) break block8;
                while (iterator.hasNext()) {
                    GasStack gasStack = iterator.next();
                    for (EnumFacing facing : EnumFacing.values()) {
                        if (capability.canReceiveGas(facing, gasStack.getGas())) {
                            gasStack.amount = gasStack.amount - capability.receiveGas(facing, gasStack.copy(), !simulate);
                        }
                        if (gasStack.amount <= 0) break;
                    }
                    if (gasStack.amount > 0) continue;
                    iterator.remove();
                }
            }
            return left.isEmpty() ? null : left;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean hasInnerChanged() {
            GasTankInfo tank;
            int i;
            IGasHandler capability = (IGasHandler)this.getCapability(null);
            if (capability == null) {
                return false;
            }
            GasTankInfo[] tanks = capability.getTankInfo();
            boolean same = true;
            if (this.lastStacks.length != tanks.length) {
                same = false;
            } else {
                for (i = 0; i < tanks.length; ++i) {
                    int lastMax;
                    int lastCap;
                    int cap;
                    tank = tanks[i];
                    GasStack content = tank.getGas();
                    GasStack lastContent = this.lastStacks[i];
                    if (content == null) {
                        if (lastContent != null) {
                            same = false;
                            break;
                        }
                    } else {
                        if (lastContent == null) {
                            same = false;
                            break;
                        }
                        if (!content.isGasEqual(lastContent)) {
                            same = false;
                            break;
                        }
                    }
                    if ((cap = tank.getStored()) != (lastCap = this.lastStoreds[i])) {
                        same = false;
                        break;
                    }
                    int max = tank.getMaxGas();
                    if (max == (lastMax = this.lastMaxs[i])) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                return false;
            }
            this.lastStacks = new GasStack[tanks.length];
            this.lastStoreds = new int[tanks.length];
            this.lastMaxs = new int[tanks.length];
            i = 0;
            while (i < tanks.length) {
                tank = tanks[i];
                GasStack gas = tank.getGas();
                this.lastStacks[i] = gas == null ? null : gas.copy();
                this.lastStoreds[i] = tank.getStored();
                this.lastMaxs[i] = tank.getMaxGas();
                ++i;
            }
            return true;
        }
    }
}

