/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.trait.GPPlayerCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class GPExtraUtilities2Capability
extends MultiblockCapability<Float> {
    public static final GPExtraUtilities2Capability CAP = new GPExtraUtilities2Capability();

    private GPExtraUtilities2Capability() {
        super("exu2_gp", new Color(13642923).getRGB());
    }

    @Override
    public Float defaultContent() {
        return Float.valueOf(15.0f);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof ComponentTileEntity && ((ComponentTileEntity)tileEntity).hasTrait(CAP);
    }

    @Override
    public Float copyInner(Float content) {
        return content;
    }

    @Override
    public Float copyInnerByModifier(Float content, ContentModifier modifier) {
        return Float.valueOf((float)modifier.apply(content.floatValue()));
    }

    public GPExtraUtilities2CapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new GPExtraUtilities2CapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Float> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("GP", this.color)).setUnit("GP");
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new GPPlayerCapabilityTrait();
    }

    public Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return Float.valueOf(json.getAsFloat());
    }

    public JsonElement serialize(Float aFloat, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)aFloat);
    }

    public static class GPExtraUtilities2CapabilityProxy
    extends CapabilityProxy<Float> {
        float lastPower;

        public GPExtraUtilities2CapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        @Override
        protected List<Float> handleRecipeInner(IO io, Recipe recipe, List<Float> left, @Nullable String slotName, boolean simulate) {
            CapabilityTrait trait;
            TileEntity te = this.getTileEntity();
            if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).hasTrait(CAP) && (trait = ((ComponentTileEntity)te).getTrait(CAP)) instanceof GPPlayerCapabilityTrait) {
                float sum = left.stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
                sum = ((GPPlayerCapabilityTrait)trait).updatePower(io == IO.IN ? sum : -sum, 2, simulate);
                return sum <= 0.0f ? null : Collections.singletonList(Float.valueOf(sum));
            }
            return left;
        }

        @Override
        protected boolean hasInnerChanged() {
            CapabilityTrait trait;
            TileEntity te = this.getTileEntity();
            if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).hasTrait(CAP) && (trait = ((ComponentTileEntity)te).getTrait(CAP)) instanceof GPPlayerCapabilityTrait && this.lastPower != ((GPPlayerCapabilityTrait)trait).getPowerCreated()) {
                this.lastPower = ((GPPlayerCapabilityTrait)trait).getPowerCreated();
                return true;
            }
            return false;
        }
    }
}

