/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.json.FluidStackTypeAdapter;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.common.capability.trait.FluidCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.FluidContentWidget;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.cleanroommc.multiblocked.util.world.DummyWorld;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FluidMultiblockCapability
extends MultiblockCapability<FluidStack> {
    public static final FluidMultiblockCapability CAP = new FluidMultiblockCapability();

    private FluidMultiblockCapability() {
        super("fluid", new Color(3961070).getRGB(), new FluidJeiAdapter());
    }

    @Override
    public FluidStack defaultContent() {
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tileEntity).isEmpty();
    }

    @Override
    public FluidStack copyInner(FluidStack content) {
        return content.copy();
    }

    @Override
    public FluidStack copyInnerByModifier(FluidStack content, ContentModifier modifier) {
        FluidStack copy = content.copy();
        copy.amount = (int)modifier.apply(content.amount);
        return copy;
    }

    public FluidCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new FluidCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super FluidStack> createContentWidget() {
        return new FluidContentWidget();
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new FluidCapabilityTrait();
    }

    @Override
    public BlockInfo[] getCandidates() {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        DummyWorld dummyWorld = new DummyWorld();
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            String path;
            if (block.getRegistryName() == null || !(path = block.getRegistryName().func_110623_a()).contains("tank") && !path.contains("fluid") && !path.contains("liquid")) continue;
            try {
                TileEntity tileEntity;
                if (!block.hasTileEntity(block.func_176223_P()) || (tileEntity = block.createTileEntity((World)dummyWorld, block.func_176223_P())) == null || !this.isBlockHasCapability(IO.BOTH, tileEntity)) continue;
                list.add(new BlockInfo(block.func_176223_P(), tileEntity));
            }
            catch (Throwable throwable) {}
        }
        return list.toArray(new BlockInfo[0]);
    }

    public FluidStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return FluidStackTypeAdapter.INSTANCE.deserialize(jsonElement, type, jsonDeserializationContext);
    }

    public JsonElement serialize(FluidStack fluidStack, Type type, JsonSerializationContext jsonSerializationContext) {
        return FluidStackTypeAdapter.INSTANCE.serialize(fluidStack, type, jsonSerializationContext);
    }

    public static class FluidJeiAdapter
    implements IJeiIngredientAdapter<FluidStack, FluidStack> {
        @Override
        public Class<FluidStack> getInternalIngredientType() {
            return FluidStack.class;
        }

        @Override
        public IIngredientType<FluidStack> getJeiIngredientType() {
            return VanillaTypes.FLUID;
        }

        @Override
        public Stream<FluidStack> apply(FluidStack fluidStack) {
            return Stream.of(fluidStack);
        }
    }

    public static class FluidCapabilityProxy
    extends CapCapabilityProxy<IFluidHandler, FluidStack> {
        FluidStack[] lastContents = new FluidStack[0];
        int[] lastCaps = new int[0];

        public FluidCapabilityProxy(TileEntity tileEntity) {
            super(MbdCapabilities.FLUID, tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        }

        @Override
        protected List<FluidStack> handleRecipeInner(IO io, Recipe recipe, List<FluidStack> left, @Nullable String slotName, boolean simulate) {
            block5: {
                Iterator<FluidStack> iterator;
                IFluidHandler capability;
                block4: {
                    capability = (IFluidHandler)this.getCapability(slotName);
                    if (capability == null) {
                        return left;
                    }
                    iterator = left.iterator();
                    if (io != IO.IN) break block4;
                    while (iterator.hasNext()) {
                        FluidStack fluidStack = iterator.next();
                        boolean found = false;
                        for (IFluidTankProperties tankProperty : capability.getTankProperties()) {
                            FluidStack stored = tankProperty.getContents();
                            if (stored == null || !stored.isFluidEqual(fluidStack)) continue;
                            found = true;
                        }
                        if (!found) continue;
                        FluidStack drained = capability.drain(fluidStack.copy(), !simulate);
                        if (drained == null) continue;
                        fluidStack.amount -= drained.amount;
                        if (fluidStack.amount > 0) continue;
                        iterator.remove();
                    }
                    break block5;
                }
                if (io != IO.OUT) break block5;
                while (iterator.hasNext()) {
                    FluidStack fluidStack = iterator.next();
                    int filled = capability.fill(fluidStack.copy(), !simulate);
                    fluidStack.amount -= filled;
                    if (fluidStack.amount > 0) continue;
                    iterator.remove();
                }
            }
            return left.isEmpty() ? null : left;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected boolean hasInnerChanged() {
            FluidStack content;
            IFluidTankProperties tank;
            int i;
            IFluidHandler capability = (IFluidHandler)this.getCapability(null);
            if (capability == null) {
                return false;
            }
            IFluidTankProperties[] tanks = capability.getTankProperties();
            boolean same = true;
            if (tanks.length != this.lastContents.length) {
                same = false;
            } else {
                for (i = 0; i < tanks.length; ++i) {
                    int lastCap;
                    int cap;
                    tank = tanks[i];
                    content = tank.getContents();
                    FluidStack lastContent = this.lastContents[i];
                    if (content == null) {
                        if (lastContent != null) {
                            same = false;
                            break;
                        }
                    } else {
                        if (lastContent == null) {
                            same = false;
                            break;
                        }
                        if (!content.isFluidEqual(lastContent) || content.amount != lastContent.amount) {
                            same = false;
                            break;
                        }
                    }
                    if ((cap = tank.getCapacity()) == (lastCap = this.lastCaps[i])) continue;
                    same = false;
                    break;
                }
            }
            if (same) {
                return false;
            }
            this.lastContents = new FluidStack[tanks.length];
            this.lastCaps = new int[tanks.length];
            i = 0;
            while (i < tanks.length) {
                tank = tanks[i];
                content = tank.getContents();
                this.lastContents[i] = content == null ? null : content.copy();
                this.lastCaps[i] = tank.getCapacity();
                ++i;
            }
            return true;
        }
    }
}

