/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.common.capability.trait.FECapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.cleanroommc.multiblocked.util.world.DummyWorld;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FEMultiblockCapability
extends MultiblockCapability<Integer> {
    public static final FEMultiblockCapability CAP = new FEMultiblockCapability();

    private FEMultiblockCapability() {
        super("forge_energy", new Color(0xCB0000).getRGB());
    }

    @Override
    public Integer defaultContent() {
        return 500;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(CapabilityEnergy.ENERGY, tileEntity).isEmpty();
    }

    @Override
    public Integer copyInner(Integer content) {
        return content;
    }

    @Override
    public Integer copyInnerByModifier(Integer content, ContentModifier modifier) {
        return (int)modifier.apply(content.intValue());
    }

    public FECapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new FECapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super Integer> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("FE", this.color)).setUnit("FE");
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new FECapabilityTrait();
    }

    @Override
    public BlockInfo[] getCandidates() {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        DummyWorld dummyWorld = new DummyWorld();
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            String path;
            if (block.getRegistryName() == null || !(path = block.getRegistryName().func_110623_a()).contains("energy") && !path.contains("rf")) continue;
            try {
                TileEntity tileEntity;
                if (!block.hasTileEntity(block.func_176223_P()) || (tileEntity = block.createTileEntity((World)dummyWorld, block.func_176223_P())) == null || !this.isBlockHasCapability(IO.BOTH, tileEntity)) continue;
                list.add(new BlockInfo(block.func_176223_P(), tileEntity));
            }
            catch (Throwable throwable) {}
        }
        return list.toArray(new BlockInfo[0]);
    }

    public Integer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return jsonElement.getAsInt();
    }

    public JsonElement serialize(Integer integer, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)integer);
    }

    public static class FECapabilityProxy
    extends CapCapabilityProxy<IEnergyStorage, Integer> {
        int stored = -1;
        boolean canExtract = false;
        boolean canReceive = false;

        public FECapabilityProxy(TileEntity tileEntity) {
            super(MbdCapabilities.FE, tileEntity, CapabilityEnergy.ENERGY);
        }

        @Override
        protected List<Integer> handleRecipeInner(IO io, Recipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            IEnergyStorage capability = (IEnergyStorage)this.getCapability(slotName);
            if (capability == null) {
                return left;
            }
            int sum = left.stream().reduce(0, Integer::sum);
            if (io == IO.IN) {
                sum -= capability.extractEnergy(sum, simulate);
            } else if (io == IO.OUT) {
                sum -= capability.receiveEnergy(sum, simulate);
            }
            return sum <= 0 ? null : Collections.singletonList(sum);
        }

        @Override
        protected boolean hasInnerChanged() {
            IEnergyStorage capability = (IEnergyStorage)this.getCapability(null);
            if (capability == null) {
                return false;
            }
            if (this.stored == capability.getEnergyStored() && this.canExtract == capability.canExtract() && this.canReceive == capability.canReceive()) {
                return false;
            }
            this.canExtract = capability.canExtract();
            this.canReceive = capability.canReceive();
            this.stored = capability.getEnergyStored();
            return true;
        }
    }
}

