/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.EntityIngredient;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.trait.EntityCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.EntityContentWidget;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class EntityMultiblockCapability
extends MultiblockCapability<EntityIngredient> {
    public static final EntityMultiblockCapability CAP = new EntityMultiblockCapability();

    private EntityMultiblockCapability() {
        super("entity", -10105955, new EntityIngredientAdapter());
    }

    @Override
    public EntityIngredient defaultContent() {
        return new EntityIngredient();
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        if (tileEntity instanceof ComponentTileEntity) {
            return ((ComponentTileEntity)tileEntity).hasTrait(CAP);
        }
        return false;
    }

    @Override
    public EntityIngredient copyInner(EntityIngredient content) {
        return content.copy();
    }

    @Override
    public EntityIngredient copyInnerByModifier(EntityIngredient content, ContentModifier modifier) {
        return content.copy();
    }

    @Override
    public CapabilityProxy<? extends EntityIngredient> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new EntityCapabilityProxy(tileEntity);
    }

    @Override
    public ContentWidget<? super EntityIngredient> createContentWidget() {
        return new EntityContentWidget();
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new EntityCapabilityTrait();
    }

    public EntityIngredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return EntityIngredient.fromJson(json);
    }

    public JsonElement serialize(EntityIngredient src, Type typeOfSrc, JsonSerializationContext context) {
        return src.toJson();
    }

    public static class EntityIngredientAdapter
    implements IJeiIngredientAdapter<EntityIngredient, ItemStack> {
        @Override
        public Class<EntityIngredient> getInternalIngredientType() {
            return EntityIngredient.class;
        }

        @Override
        public IIngredientType<ItemStack> getJeiIngredientType() {
            return VanillaTypes.ITEM;
        }

        @Override
        public Stream<ItemStack> apply(EntityIngredient content) {
            if (content.isEntityItem()) {
                return Stream.of(content.getEntityItem());
            }
            EntityList.EntityEggInfo egg = content.type.getEgg();
            if (egg == null) {
                return Stream.empty();
            }
            ItemStack itemStack = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)new ItemStack(Items.field_151063_bx), (ResourceLocation)egg.field_75613_a);
            return Stream.of(itemStack);
        }
    }

    public static class EntityCapabilityProxy
    extends CapabilityProxy<EntityIngredient> {
        Set<Entity> entities = new HashSet<Entity>();

        public EntityCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        @Override
        protected List<EntityIngredient> handleRecipeInner(IO io, Recipe recipe, List<EntityIngredient> left, @Nullable String slotName, boolean simulate) {
            TileEntity tileEntity = this.getTileEntity();
            if (tileEntity instanceof ComponentTileEntity) {
                ComponentTileEntity component = (ComponentTileEntity)tileEntity;
                BlockPos pos = component.func_174877_v().func_177972_a(component.getFrontFacing());
                if (io == IO.IN) {
                    List entities = component.func_145831_w().func_72839_b(null, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
                    for (Entity entity : entities) {
                        if (entity.field_70128_L || !left.removeIf(ingredient -> ingredient.match(entity)) || simulate) continue;
                        entity.func_70106_y();
                    }
                } else if (io == IO.OUT) {
                    if (!simulate) {
                        for (EntityIngredient ingredient2 : left) {
                            ingredient2.spawn(component.func_145831_w(), ingredient2.tag, pos);
                        }
                    }
                    return null;
                }
            }
            return left.isEmpty() ? null : left;
        }

        @Override
        protected boolean hasInnerChanged() {
            if (this.getTileEntity() instanceof ComponentTileEntity) {
                ComponentTileEntity component = (ComponentTileEntity)this.getTileEntity();
                BlockPos pos = component.func_174877_v().func_177972_a(component.getFrontFacing());
                List entities = component.func_145831_w().func_72839_b(null, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
                HashSet<Entity> temp = new HashSet<Entity>();
                for (Entity entity : entities) {
                    if (entity.field_70128_L) continue;
                    temp.add(entity);
                }
                if (this.entities.size() == temp.size() && this.entities.containsAll(temp)) {
                    return false;
                }
                this.entities = temp;
                return true;
            }
            return false;
        }
    }
}

