/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapCapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.trait.EnergyCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.cleanroommc.multiblocked.common.capability.widget.TieredNumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityEnergyHatch;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class EnergyGTCECapability
extends MultiblockCapability<Long> {
    public static final EnergyGTCECapability CAP = new EnergyGTCECapability();

    public EnergyGTCECapability() {
        super("gtce_energy", new Color(15974949).getRGB());
    }

    @Override
    public Long defaultContent() {
        return 256L;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return !this.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, tileEntity).isEmpty();
    }

    @Override
    public Long copyInner(Long content) {
        return content;
    }

    @Override
    public Long copyInnerByModifier(Long content, ContentModifier modifier) {
        return (long)modifier.apply(content.longValue());
    }

    public EnergyCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        EnergyCapabilityProxy energyCapabilityProxy = new EnergyCapabilityProxy(tileEntity);
        energyCapabilityProxy.facing = this.getFrontFacing(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, tileEntity);
        return energyCapabilityProxy;
    }

    @Override
    public ContentWidget<? super Long> createContentWidget() {
        if (this.isCEu()) {
            return new TieredNumberContentWidget().setTierFunction(EU -> String.format(" (%s)", GTValues.VNF[GTUtility.getTierByVoltage((long)EU)] + TextFormatting.RESET)).setContentTexture(new TextTexture("EU", this.color)).setUnit("EU");
        }
        return new NumberContentWidget().setContentTexture(new TextTexture("EU", this.color)).setUnit("eu");
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new EnergyCapabilityTrait();
    }

    public boolean isCEu() {
        String version = ((ModContainer)Loader.instance().getIndexedModList().get("gregtech")).getVersion();
        return Integer.parseInt(version.split("\\.")[0]) >= 2;
    }

    @Override
    public BlockInfo[] getCandidates() {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        if (this.isCEu()) {
            ItemStack itemStack;
            MetaTileEntityHolder holder;
            IBlockState blockState = GregTechAPI.MACHINE.func_176223_P();
            for (MetaTileEntityEnergyHatch energyInputHatch : MetaTileEntities.ENERGY_INPUT_HATCH) {
                if (energyInputHatch == null) continue;
                holder = new MetaTileEntityHolder();
                itemStack = energyInputHatch.getStackForm();
                holder.setMetaTileEntity((MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_148754_a(itemStack.func_77952_i()));
                list.add(new BlockInfo(blockState, (TileEntity)holder, itemStack));
            }
            for (MetaTileEntityEnergyHatch energyOutputHatch : MetaTileEntities.ENERGY_OUTPUT_HATCH) {
                if (energyOutputHatch == null) continue;
                holder = new MetaTileEntityHolder();
                itemStack = energyOutputHatch.getStackForm();
                holder.setMetaTileEntity((MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_148754_a(itemStack.func_77952_i()));
                list.add(new BlockInfo(blockState, (TileEntity)holder, itemStack));
            }
        }
        return list.toArray(new BlockInfo[0]);
    }

    public Long deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return jsonElement.getAsLong();
    }

    public JsonElement serialize(Long integer, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive((Number)integer);
    }

    public static class EnergyCapabilityProxy
    extends CapCapabilityProxy<IEnergyContainer, Long> {
        long stored = -1L;

        public EnergyCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity, GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER);
        }

        @Override
        public IEnergyContainer getCapability(@Nullable String slotName) {
            IEnergyContainer tempCapability = (IEnergyContainer)super.getCapability(slotName);
            if (tempCapability == null) {
                this.facing = CAP.getFrontFacing(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, this.getTileEntity());
            }
            return (IEnergyContainer)super.getCapability(slotName);
        }

        @Override
        protected List<Long> handleRecipeInner(IO io, Recipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
            IEnergyContainer capability = this.getCapability(slotName);
            if (capability == null) {
                return left;
            }
            long sum = left.stream().reduce(0L, Long::sum);
            if (io == IO.IN) {
                if (!simulate) {
                    capability.addEnergy(-Math.min(capability.getEnergyStored(), sum));
                }
                sum -= capability.getEnergyStored();
            } else if (io == IO.OUT) {
                long canInput = capability.getEnergyCapacity() - capability.getEnergyStored();
                if (!simulate) {
                    capability.addEnergy(Math.min(canInput, sum));
                }
                sum -= canInput;
            }
            return sum <= 0L ? null : Collections.singletonList(sum);
        }

        @Override
        protected boolean hasInnerChanged() {
            IEnergyContainer capability = this.getCapability(null);
            if (capability == null) {
                return false;
            }
            if (capability.getEnergyStored() == this.stored) {
                return false;
            }
            this.stored = capability.getEnergyStored();
            return true;
        }
    }
}

