/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.common.capability.trait.EMCPlayerCapabilityTrait;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.tileentity.TileEntity;

public class EMCProjectECapability
extends MultiblockCapability<Long> {
    public static final EMCProjectECapability CAP = new EMCProjectECapability();

    protected EMCProjectECapability() {
        super("projecte_emc", new Color(11283806).getRGB());
    }

    @Override
    public Long defaultContent() {
        return 1L;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof ComponentTileEntity && ((ComponentTileEntity)tileEntity).hasTrait(CAP);
    }

    @Override
    public Long copyInner(Long content) {
        return content;
    }

    @Override
    public Long copyInnerByModifier(Long content, ContentModifier modifier) {
        return (long)modifier.apply(content.longValue());
    }

    @Override
    public CapabilityProxy<? extends Long> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new EMCProjectECapabilityProxy(tileEntity);
    }

    public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return json.getAsLong();
    }

    public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }

    @Override
    public ContentWidget<? super Long> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("EMC", this.color)).setUnit("EMC");
    }

    @Override
    public boolean hasTrait() {
        return true;
    }

    @Override
    public CapabilityTrait createTrait() {
        return new EMCPlayerCapabilityTrait();
    }

    public static class EMCProjectECapabilityProxy
    extends CapabilityProxy<Long> {
        long lastEMC = Long.MIN_VALUE;

        public EMCProjectECapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public EMCPlayerCapabilityTrait getTrait() {
            CapabilityTrait trait;
            TileEntity te = this.getTileEntity();
            if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).hasTrait(CAP) && (trait = ((ComponentTileEntity)te).getTrait(CAP)) instanceof EMCPlayerCapabilityTrait) {
                return (EMCPlayerCapabilityTrait)trait;
            }
            return null;
        }

        @Override
        protected List<Long> handleRecipeInner(IO io, Recipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
            EMCPlayerCapabilityTrait trait = this.getTrait();
            if (trait == null) {
                return left;
            }
            long sum = left.stream().reduce(0L, Long::sum);
            sum = trait.updateEMC(io == IO.IN ? -sum : sum, simulate);
            return sum <= 0L ? null : Collections.singletonList(sum);
        }

        @Override
        protected boolean hasInnerChanged() {
            EMCPlayerCapabilityTrait trait = this.getTrait();
            if (trait == null) {
                return false;
            }
            IKnowledgeProvider capability = trait.getCapability();
            if (capability == null) {
                return false;
            }
            if (this.lastEMC == capability.getEmc()) {
                return false;
            }
            this.lastEMC = capability.getEmc();
            return true;
        }
    }
}

