/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.MbdConfig;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.NumberContentWidget;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AuraMultiblockCapability
extends MultiblockCapability<Integer> {
    public static final AuraMultiblockCapability CAP = new AuraMultiblockCapability();

    private AuraMultiblockCapability() {
        super("natures_aura", new Color(9826197).getRGB());
    }

    @Override
    public Integer defaultContent() {
        return 200;
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return true;
    }

    @Override
    public Integer copyInner(Integer content) {
        return content;
    }

    @Override
    public Integer copyInnerByModifier(Integer content, ContentModifier modifier) {
        return (int)modifier.apply(content.intValue());
    }

    @Override
    public CapabilityProxy<? extends Integer> createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new ManaBotainaCapabilityProxy(tileEntity);
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(Blocks.field_150460_al.func_176223_P()), BlockInfo.fromBlockState(Blocks.field_150486_ae.func_176223_P()), BlockInfo.fromBlockState(Blocks.field_150438_bZ.func_176223_P()), BlockInfo.fromBlockState(Blocks.field_150477_bB.func_176223_P())};
    }

    public Integer deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return jsonElement.getAsInt();
    }

    public JsonElement serialize(Integer integer, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)integer);
    }

    @Override
    public ContentWidget<? super Integer> createContentWidget() {
        return new NumberContentWidget().setContentTexture(new TextTexture("NA", this.color)).setUnit("NaturesAura");
    }

    public static class ManaBotainaCapabilityProxy
    extends CapabilityProxy<Integer> {
        int lastMana = Integer.MIN_VALUE;

        public ManaBotainaCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        @Override
        protected List<Integer> handleRecipeInner(IO io, Recipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            World world = this.getTileEntity().func_145831_w();
            BlockPos pos = this.getTileEntity().func_174877_v();
            int sum = left.stream().reduce(0, Integer::sum);
            if (io == IO.IN) {
                if (!simulate) {
                    BlockPos spot = IAuraChunk.getHighestSpot((World)world, (BlockPos)pos, (int)MbdConfig.naturesAura.radius, (BlockPos)pos);
                    IAuraChunk.getAuraChunk((World)world, (BlockPos)spot).drainAura(pos, sum);
                }
            } else if (io == IO.OUT && !simulate) {
                BlockPos spot = IAuraChunk.getLowestSpot((World)world, (BlockPos)pos, (int)MbdConfig.naturesAura.radius, (BlockPos)pos);
                IAuraChunk.getAuraChunk((World)world, (BlockPos)spot).storeAura(pos, sum);
            }
            return null;
        }

        @Override
        protected boolean hasInnerChanged() {
            int auraInArea = IAuraChunk.getAuraInArea((World)this.getTileEntity().func_145831_w(), (BlockPos)this.getTileEntity().func_174877_v(), (int)MbdConfig.naturesAura.radius);
            if (this.lastMana == auraInArea) {
                return false;
            }
            this.lastMana = auraInArea;
            return true;
        }
    }
}

