/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.common.capability;

import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.gui.widget.imp.recipe.ContentWidget;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.recipe.ContentModifier;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.common.capability.widget.AspectStackWidget;
import com.cleanroommc.multiblocked.common.recipe.content.AspectStack;
import com.cleanroommc.multiblocked.jei.IJeiIngredientAdapter;
import com.cleanroommc.multiblocked.jei.ingredient.AspectListIngredient;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.blocks.BlocksTC;

public class AspectThaumcraftCapability
extends MultiblockCapability<AspectStack> {
    public static final AspectThaumcraftCapability CAP = new AspectThaumcraftCapability();

    private AspectThaumcraftCapability() {
        super("tc6_aspect", new Color(13304008).getRGB(), new AspectJeiAdapter());
    }

    @Override
    public AspectStack defaultContent() {
        return new AspectStack(Aspect.AIR, 1);
    }

    @Override
    public boolean isBlockHasCapability(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return tileEntity instanceof IAspectContainer;
    }

    public AspectThaumcraftCapabilityProxy createProxy(@Nonnull IO io, @Nonnull TileEntity tileEntity) {
        return new AspectThaumcraftCapabilityProxy(tileEntity);
    }

    @Override
    public AspectStack copyInner(AspectStack content) {
        return content.copy();
    }

    @Override
    public AspectStack copyInnerByModifier(AspectStack content, ContentModifier modifier) {
        AspectStack copy = content.copy();
        copy.amount = (int)modifier.apply(content.amount);
        return copy;
    }

    @Override
    public ContentWidget<AspectStack> createContentWidget() {
        return new AspectStackWidget();
    }

    @Override
    public BlockInfo[] getCandidates() {
        return new BlockInfo[]{BlockInfo.fromBlockState(BlocksTC.jarNormal.func_176223_P()), BlockInfo.fromBlockState(BlocksTC.jarVoid.func_176223_P())};
    }

    public AspectStack deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return new AspectStack(Aspect.getAspect((String)jsonElement.getAsJsonObject().get("aspect").getAsString()), jsonElement.getAsJsonObject().get("amount").getAsInt());
    }

    public JsonElement serialize(AspectStack aspectStack, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("aspect", aspectStack.aspect.getTag());
        jsonObj.addProperty("amount", (Number)aspectStack.amount);
        return jsonObj;
    }

    public static class AspectJeiAdapter
    implements IJeiIngredientAdapter<AspectStack, AspectList> {
        @Override
        public Class<AspectStack> getInternalIngredientType() {
            return AspectStack.class;
        }

        @Override
        public IIngredientType<AspectList> getJeiIngredientType() {
            return AspectListIngredient.INSTANCE;
        }

        @Override
        public Stream<AspectList> apply(AspectStack aspectStack) {
            return Stream.of(aspectStack.toAspectList());
        }
    }

    public static class AspectThaumcraftCapabilityProxy
    extends CapabilityProxy<AspectStack> {
        AspectList lastAspectList;

        public AspectThaumcraftCapabilityProxy(TileEntity tileEntity) {
            super(CAP, tileEntity);
        }

        public IAspectContainer getCapability() {
            return (IAspectContainer)this.getTileEntity();
        }

        @Override
        protected List<AspectStack> handleRecipeInner(IO io, Recipe recipe, List<AspectStack> left, @Nullable String slotName, boolean simulate) {
            block6: {
                Iterator<AspectStack> iterator;
                IAspectContainer capability;
                block5: {
                    capability = this.getCapability();
                    if (capability == null || capability.getAspects() == null) {
                        return left;
                    }
                    iterator = left.iterator();
                    if (io != IO.IN) break block5;
                    while (iterator.hasNext()) {
                        AspectStack aspectStack = iterator.next();
                        Aspect aspect = aspectStack.aspect;
                        int amount = aspectStack.amount;
                        if (!ArrayUtils.contains((Object[])capability.getAspects().getAspects(), (Object)aspect)) continue;
                        int stored = capability.getAspects().getAmount(aspect);
                        aspectStack.amount = Math.max(0, amount - stored);
                        if (!simulate && !capability.takeFromContainer(aspect, Math.min(stored, amount))) {
                            aspectStack.amount = amount;
                        }
                        if (aspectStack.amount > 0) continue;
                        iterator.remove();
                    }
                    break block6;
                }
                if (io != IO.OUT) break block6;
                while (iterator.hasNext()) {
                    int ll;
                    AspectStack aspectStack = iterator.next();
                    Aspect aspect = aspectStack.aspect;
                    int amount = aspectStack.amount;
                    aspectStack.amount = ll = capability.addToContainer(aspect, amount);
                    if (simulate && amount - ll > 0) {
                        capability.takeFromContainer(aspect, amount - ll);
                    }
                    if (aspectStack.amount > 0) continue;
                    iterator.remove();
                }
            }
            return left.isEmpty() ? null : left;
        }

        @Override
        protected boolean hasInnerChanged() {
            IAspectContainer capability = this.getCapability();
            if (capability == null) {
                return false;
            }
            AspectList aspectList = capability.getAspects();
            if (this.lastAspectList != null) {
                return !aspectList.aspects.equals(this.lastAspectList.aspects);
            }
            this.lastAspectList = aspectList.copy();
            return true;
        }
    }
}

