/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.command;

import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandMbdTps
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "tps";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "multiblocked async thread tps";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        if (sender instanceof EntityPlayerMP) {
            StringBuilder tps = new StringBuilder();
            float sumTps = 0.0f;
            for (WorldServer world : server.field_71305_c) {
                MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate((World)world);
                long periodID = mwsd.getPeriodID();
                float worldTPS = mwsd.getTPS();
                sumTps += worldTPS;
                tps.append(String.format(CommandMbdTps.getDimensionPrefix(world.field_73011_w.getDimension()) + ": PeriodID: %d. Mean TPS: %.2f\n", periodID, Float.valueOf(worldTPS)));
            }
            tps.append(String.format("Overall: Mean TPS: %.2f", Float.valueOf(sumTps / (float)server.field_71305_c.length)));
            sender.func_145747_a((ITextComponent)new TextComponentString(tps.toString()));
        }
    }

    private static String getDimensionPrefix(int dimId) {
        DimensionType providerType = DimensionManager.getProviderType((int)dimId);
        if (providerType == null) {
            return String.format("Dim %2d", dimId);
        }
        return String.format("Dim %2d (%s)", dimId, providerType.func_186065_b());
    }
}

