/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.util;

import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    private static final Stack<int[]> scissorFrameStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useScissor(int x, int y, int width, int height, Runnable codeBlock) {
        RenderUtils.pushScissorFrame(x, y, width, height);
        try {
            codeBlock.run();
        }
        finally {
            RenderUtils.popScissorFrame();
        }
    }

    private static int[] peekFirstScissorOrFullScreen() {
        int[] currentTopFrame;
        int[] nArray = currentTopFrame = scissorFrameStack.isEmpty() ? null : scissorFrameStack.peek();
        if (currentTopFrame == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            return new int[]{0, 0, minecraft.field_71443_c, minecraft.field_71440_d};
        }
        return currentTopFrame;
    }

    public static void pushScissorFrame(int x, int y, int width, int height) {
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        boolean pushedFrame = false;
        if (x <= parentX + parentWidth && y <= parentY + parentHeight) {
            int newX = Math.max(x, parentX);
            int newY = Math.max(y, parentY);
            int newWidth = width - (newX - x);
            int newHeight = height - (newY - y);
            if (newWidth > 0 && newHeight > 0) {
                int maxWidth = parentWidth - (x - parentX);
                int maxHeight = parentHeight - (y - parentY);
                newWidth = Math.min(maxWidth, newWidth);
                newHeight = Math.min(maxHeight, newHeight);
                RenderUtils.applyScissor(newX, newY, newWidth, newHeight);
                if (scissorFrameStack.isEmpty()) {
                    GL11.glEnable((int)3089);
                }
                scissorFrameStack.push(new int[]{newX, newY, newWidth, newHeight});
                pushedFrame = true;
            }
        }
        if (!pushedFrame) {
            if (scissorFrameStack.isEmpty()) {
                GL11.glEnable((int)3089);
            }
            scissorFrameStack.push(new int[]{parentX, parentY, parentWidth, parentHeight});
        }
    }

    public static void popScissorFrame() {
        scissorFrameStack.pop();
        int[] parentScissor = RenderUtils.peekFirstScissorOrFullScreen();
        int parentX = parentScissor[0];
        int parentY = parentScissor[1];
        int parentWidth = parentScissor[2];
        int parentHeight = parentScissor[3];
        RenderUtils.applyScissor(parentX, parentY, parentWidth, parentHeight);
        if (scissorFrameStack.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    private static void applyScissor(int x, int y, int w, int h) {
        ScaledResolution r = ((GuiIngameForge)Minecraft.func_71410_x().field_71456_v).getResolution();
        int s = r.func_78325_e();
        int translatedY = r.func_78328_b() - y - h;
        GL11.glScissor((int)(x * s), (int)(translatedY * s), (int)(w * s), (int)(h * s));
    }

    public static void renderBlockOverLay(BlockPos pos, float r, float g, float b, float scale) {
        if (pos == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179090_x();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtils.renderCubeFace(buffer, -0.5, -0.5, -0.5, 0.5, 0.5, 0.5, r, g, b, 1.0f);
        tessellator.func_78381_a();
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GlStateManager.func_179137_b((double)(-((double)pos.func_177958_n() + 0.5)), (double)(-((double)pos.func_177956_o() + 0.5)), (double)(-((double)pos.func_177952_p() + 0.5)));
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCubeFace(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void useLightMap(float x, float y, Runnable codeBlock) {
        GL11.glPushAttrib((int)64);
        RenderHelper.func_74518_a();
        float lastBrightnessX = OpenGlHelper.lastBrightnessX;
        float lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
        if (codeBlock != null) {
            codeBlock.run();
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
    }

    public static void moveToFace(double x, double y, double z, EnumFacing face) {
        GlStateManager.func_179137_b((double)(x + 0.5 + (double)face.func_82601_c() * 0.5), (double)(y + 0.5 + (double)face.func_96559_d() * 0.5), (double)(z + 0.5 + (double)face.func_82599_e() * 0.5));
    }

    public static void rotateToFace(EnumFacing face, @Nullable EnumFacing spin) {
        int angle = spin == EnumFacing.EAST ? 90 : (spin == EnumFacing.SOUTH ? 180 : (spin == EnumFacing.WEST ? -90 : 0));
        switch (face) {
            case UP: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(spin == EnumFacing.EAST ? 90.0f : (spin == EnumFacing.NORTH ? 180.0f : (spin == EnumFacing.WEST ? -90.0f : 0.0f))), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case NORTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
        }
    }
}

