/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.shader.uniform;

import com.cleanroommc.multiblocked.client.shader.uniform.UniformEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.FloatBuffer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.lwjgl.opengl.GL20;

public class UniformCache {
    private final Int2ObjectMap<UniformEntry> entryCache = new Int2ObjectOpenHashMap();
    private final Object2IntMap<String> locationCache = new Object2IntOpenHashMap();
    private final int programId;

    public UniformCache(int programId) {
        this.programId = programId;
    }

    public void invalidate() {
        this.entryCache.clear();
        this.locationCache.clear();
    }

    public void glUniform1F(String location, float v0) {
        this.glUniformF(location, loc -> GL20.glUniform1f((int)loc, (float)v0), v0);
    }

    public void glUniform2F(String location, float v0, float v1) {
        this.glUniformF(location, loc -> GL20.glUniform2f((int)loc, (float)v0, (float)v1), v0, v1);
    }

    public void glUniform3F(String location, float v0, float v1, float v2) {
        this.glUniformF(location, loc -> GL20.glUniform3f((int)loc, (float)v0, (float)v1, (float)v2), v0, v1, v2);
    }

    public void glUniform4F(String location, float v0, float v1, float v2, float v3) {
        this.glUniformF(location, loc -> GL20.glUniform4f((int)loc, (float)v0, (float)v1, (float)v2, (float)v3), v0, v1, v2, v3);
    }

    private void glUniformF(String location, IntConsumer callback, float ... values) {
        this.glUniform(location, UniformEntry.IS_FLOAT, UniformEntry.FloatUniformEntry.NEW, callback, values);
    }

    public void glUniform1I(String location, int v0) {
        this.glUniformI(location, loc -> GL20.glUniform1i((int)loc, (int)v0), v0);
    }

    public void glUniform2I(String location, int v0, int v1) {
        this.glUniformI(location, loc -> GL20.glUniform2i((int)loc, (int)v0, (int)v1), v0, v1);
    }

    public void glUniform3I(String location, int v0, int v1, int v2) {
        this.glUniformI(location, loc -> GL20.glUniform3i((int)loc, (int)v0, (int)v1, (int)v2), v0, v1, v2);
    }

    public void glUniform4I(String location, int v0, int v1, int v2, int v3) {
        this.glUniformI(location, loc -> GL20.glUniform4i((int)loc, (int)v0, (int)v1, (int)v2, (int)v3), v0, v1, v2, v3);
    }

    private void glUniformI(String location, IntConsumer callback, int ... values) {
        this.glUniform(location, UniformEntry.IS_INT, UniformEntry.IntUniformEntry.NEW, callback, values);
    }

    public void glUniformMatrix2(String location, boolean transpose, FloatBuffer matrix) {
        this.glUniformMatrix(location, loc -> GL20.glUniformMatrix2((int)loc, (boolean)transpose, (FloatBuffer)matrix), transpose, matrix);
    }

    public void glUniformMatrix4(String location, boolean transpose, FloatBuffer matrix) {
        this.glUniformMatrix(location, loc -> GL20.glUniformMatrix4((int)loc, (boolean)transpose, (FloatBuffer)matrix), transpose, matrix);
    }

    public void glUniformMatrix(String location, IntConsumer callback, boolean transpose, FloatBuffer matrix) {
        this.glUniform(location, UniformEntry.IS_MATRIX, UniformEntry.MatrixUniformEntry.NEW, callback, ImmutablePair.of((Object)matrix, (Object)transpose));
    }

    public void glUniformBoolean(String location, boolean value) {
        this.glUniform(location, UniformEntry.IS_BOOLEAN, UniformEntry.BooleanUniformEntry.NEW, loc -> GL20.glUniform1i((int)loc, (int)(value ? 1 : 0)), value);
    }

    private int getUniformLocation(String name) {
        int uniformLocation;
        if (this.locationCache.containsKey((Object)name)) {
            uniformLocation = (Integer)this.locationCache.get((Object)name);
        } else {
            uniformLocation = GL20.glGetUniformLocation((int)this.programId, (CharSequence)name);
            this.locationCache.put((Object)name, uniformLocation);
        }
        return uniformLocation;
    }

    private <T> void glUniform(String location, Predicate<UniformEntry> isType, Function<T, UniformEntry<T>> createUniform, IntConsumer applyCallback, T value) {
        UniformEntry uniformEntry;
        int loc = this.getUniformLocation(location);
        boolean update = true;
        if (this.entryCache.containsKey(loc) && isType.test(uniformEntry = (UniformEntry)this.entryCache.get(loc))) {
            boolean bl = update = !uniformEntry.check(value);
        }
        if (update) {
            UniformEntry<T> entry = createUniform.apply(value);
            applyCallback.accept(loc);
            this.entryCache.put(loc, entry);
        }
    }
}

