/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.shader.management;

import com.cleanroommc.multiblocked.client.shader.management.Shader;
import com.cleanroommc.multiblocked.client.shader.uniform.IUniformCallback;
import com.cleanroommc.multiblocked.client.shader.uniform.UniformCache;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class ShaderProgram {
    public final int programId = GL20.glCreateProgram();
    public final Set<Shader> shaders = new ReferenceOpenHashSet();
    public final UniformCache uniformCache;
    private boolean unLinked;

    public ShaderProgram() {
        if (this.programId == 0) {
            throw new IllegalStateException("Unable to create ShaderProgram.");
        }
        this.uniformCache = new UniformCache(this.programId);
    }

    public ShaderProgram attach(Shader loader) {
        if (loader == null) {
            return this;
        }
        if (this.shaders.contains(loader)) {
            throw new IllegalStateException(String.format("Unable to attach Shader as it is already attached:\n%s", loader.source));
        }
        this.shaders.add(loader);
        loader.attachShader(this);
        this.unLinked = true;
        return this;
    }

    public void use(IUniformCallback callback) {
        this.use();
        callback.apply(this.uniformCache);
    }

    public void use() {
        if (this.unLinked) {
            this.uniformCache.invalidate();
            GL20.glLinkProgram((int)this.programId);
            if (GL20.glGetProgrami((int)this.programId, (int)35714) == 0) {
                throw new RuntimeException(String.format("ShaderProgram validation has failed!\n%s", GL20.glGetProgramInfoLog((int)this.programId, (int)GL20.glGetProgrami((int)this.programId, (int)35716))));
            }
            this.unLinked = false;
        }
        GL20.glUseProgram((int)this.programId);
    }

    public void release() {
        GL20.glUseProgram((int)0);
    }

    public void delete() {
        if (this.programId != 0) {
            GL20.glDeleteProgram((int)this.programId);
        }
    }
}

