/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.shader.management;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.client.shader.Shaders;
import com.cleanroommc.multiblocked.client.shader.management.Shader;
import com.cleanroommc.multiblocked.client.shader.management.ShaderProgram;
import com.cleanroommc.multiblocked.client.shader.uniform.UniformCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.lang.reflect.Field;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShaderManager {
    private static final BooleanSupplier optifine$shaderPackLoaded;
    private static final ShaderManager INSTANCE;
    private final Reference2ReferenceMap<Shader, ShaderProgram> programs = new Reference2ReferenceOpenHashMap();

    public static ShaderManager getInstance() {
        return INSTANCE;
    }

    public static boolean allowedShader() {
        return OpenGlHelper.field_148824_g;
    }

    public static boolean isShadersCompatible() {
        return OpenGlHelper.func_153193_b() && !optifine$shaderPackLoaded.getAsBoolean();
    }

    private ShaderManager() {
    }

    public Framebuffer renderFullImageInFramebuffer(Framebuffer fbo, Shader frag, Consumer<UniformCache> consumeCache) {
        if (fbo == null || frag == null || !ShaderManager.allowedShader()) {
            return fbo;
        }
        fbo.func_147610_a(true);
        ShaderProgram program = (ShaderProgram)this.programs.get((Object)frag);
        if (program == null) {
            program = new ShaderProgram();
            this.programs.put((Object)frag, (Object)program);
            program.attach(Shaders.IMAGE_V).attach(frag);
        }
        program.use(cache -> {
            cache.glUniform2F("iResolution", fbo.field_147621_c, fbo.field_147618_d);
            if (consumeCache != null) {
                consumeCache.accept(cache);
            }
        });
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(-1.0, 1.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(-1.0, -1.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, -1.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        program.release();
        return fbo;
    }

    static {
        Field shaderPackLoadedField = null;
        try {
            Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
            shaderPackLoadedField = shadersClass.getDeclaredField("shaderPackLoaded");
        }
        catch (Exception ignored) {
            Multiblocked.LOGGER.debug("Cannot detect Optifine, not going to do any specific compatibility patches.");
        }
        if (shaderPackLoadedField == null) {
            optifine$shaderPackLoaded = () -> false;
        } else {
            Field finalShaderPackLoadedField = shaderPackLoadedField;
            optifine$shaderPackLoaded = () -> {
                try {
                    return finalShaderPackLoadedField.getBoolean(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
            };
        }
        INSTANCE = new ShaderManager();
    }
}

