/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.shader.management;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.client.shader.management.ShaderProgram;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
public class Shader {
    public final ShaderType shaderType;
    public final String source;
    private int shaderId;
    private boolean isCompiled;

    public Shader(ShaderType type, String source) {
        this.shaderType = type;
        this.source = source;
        this.shaderId = GL20.glCreateShader((int)this.shaderType.shaderMode);
        if (this.shaderId == 0) {
            Multiblocked.LOGGER.error("GL Shader Allocation Fail!");
            throw new RuntimeException("GL Shader Allocation Fail!");
        }
    }

    public void attachShader(ShaderProgram program) {
        if (!this.isCompiled) {
            this.compileShader();
        }
        OpenGlHelper.func_153178_b((int)program.programId, (int)this.shaderId);
    }

    public void deleteShader() {
        if (this.shaderId == 0) {
            return;
        }
        OpenGlHelper.func_153180_a((int)this.shaderId);
        this.shaderId = 0;
    }

    public Shader compileShader() {
        if (!this.isCompiled && this.shaderId != 0) {
            GL20.glShaderSource((int)this.shaderId, (CharSequence)this.source);
            GL20.glCompileShader((int)this.shaderId);
            if (GL20.glGetShaderi((int)this.shaderId, (int)OpenGlHelper.field_153208_p) == 0) {
                int maxLength = GL20.glGetShaderi((int)this.shaderId, (int)35716);
                String error = String.format("Unable to compile %s shader object:\n%s", this.shaderType.name(), GL20.glGetShaderInfoLog((int)this.shaderId, (int)maxLength));
                Multiblocked.LOGGER.error(error);
                throw new IllegalStateException(error);
            }
            this.isCompiled = true;
        }
        return this;
    }

    public static Shader loadShader(ShaderType type, String rawShader) {
        return new Shader(type, rawShader).compileShader();
    }

    public static Shader loadShader(ShaderType type, ResourceLocation resourceLocation) throws IOException {
        String line;
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
        InputStream stream = iresource.func_110527_b();
        StringBuilder sb = new StringBuilder();
        BufferedReader bin = new BufferedReader(new InputStreamReader(stream));
        while ((line = bin.readLine()) != null) {
            sb.append(line).append('\n');
        }
        stream.close();
        IOUtils.closeQuietly((Closeable)iresource);
        return Shader.loadShader(type, sb.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static enum ShaderType {
        VERTEX("vertex", ".vert", OpenGlHelper.field_153209_q),
        FRAGMENT("fragment", ".frag", OpenGlHelper.field_153210_r);

        public final String shaderName;
        public final String shaderExtension;
        public final int shaderMode;

        private ShaderType(String shaderNameIn, String shaderExtensionIn, int shaderModeIn) {
            this.shaderName = shaderNameIn;
            this.shaderExtension = shaderExtensionIn;
            this.shaderMode = shaderModeIn;
        }
    }
}

