/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.shader;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.client.shader.management.Shader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Shaders {
    public static Shader IMAGE_F;
    public static Shader IMAGE_V;
    public static Shader FBM;
    public static Map<ResourceLocation, Shader> CACHE;

    public static void init() {
        IMAGE_F = Shaders.load(Shader.ShaderType.FRAGMENT, new ResourceLocation("multiblocked", "image"));
        IMAGE_V = Shaders.load(Shader.ShaderType.VERTEX, new ResourceLocation("multiblocked", "image"));
        FBM = Shaders.load(Shader.ShaderType.FRAGMENT, new ResourceLocation("multiblocked", "fbm"));
    }

    public static void reload() {
        for (Shader shader : CACHE.values()) {
            if (shader == null) continue;
            shader.deleteShader();
        }
        CACHE.clear();
        Shaders.init();
    }

    public static Shader load(Shader.ShaderType shaderType, ResourceLocation resourceLocation) {
        return CACHE.computeIfAbsent(new ResourceLocation(resourceLocation.func_110624_b(), "shaders/" + resourceLocation.func_110623_a() + shaderType.shaderExtension), key -> {
            try {
                return Shader.loadShader(shaderType, key);
            }
            catch (IOException e) {
                Multiblocked.LOGGER.error("load shader {} resource {} failed", (Object)shaderType, (Object)resourceLocation);
                return null;
            }
        });
    }

    static {
        CACHE = new HashMap<ResourceLocation, Shader>();
    }
}

