/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.scene;

import com.cleanroommc.multiblocked.client.particle.ParticleManager;
import com.cleanroommc.multiblocked.client.renderer.scene.ISceneRenderHook;
import com.cleanroommc.multiblocked.client.util.EntityCamera;
import com.cleanroommc.multiblocked.client.util.TrackedDummyWorld;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import com.cleanroommc.multiblocked.util.Position;
import com.cleanroommc.multiblocked.util.PositionedRect;
import com.cleanroommc.multiblocked.util.Size;
import com.cleanroommc.multiblocked.util.Vector3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

@SideOnly(value=Side.CLIENT)
public abstract class WorldSceneRenderer {
    protected static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final World world;
    public final Map<Collection<BlockPos>, ISceneRenderHook> renderedBlocksMap;
    protected VertexBuffer[] vertexBuffers;
    protected Set<BlockPos> tileEntities;
    protected boolean useCache;
    protected AtomicReference<CacheState> cacheState;
    protected int maxProgress;
    protected int progress;
    protected Thread thread;
    protected ParticleManager particleManager;
    protected EntityCamera viewEntity;
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> afterRender;
    private Consumer<RayTraceResult> onLookingAt;
    protected int clearColor;
    private RayTraceResult lastTraceResult;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);

    public WorldSceneRenderer(World world) {
        this.world = world;
        this.renderedBlocksMap = new LinkedHashMap<Collection<BlockPos>, ISceneRenderHook>();
        this.cacheState = new AtomicReference<CacheState>(CacheState.UNUSED);
    }

    public WorldSceneRenderer setParticleManager(ParticleManager particleManager) {
        if (particleManager == null) {
            this.particleManager = null;
            this.viewEntity = null;
            return this;
        }
        this.particleManager = particleManager;
        this.viewEntity = new EntityCamera(this.world);
        this.setCameraLookAt(this.eyePos, this.lookAt, this.worldUp);
        return this;
    }

    public WorldSceneRenderer useCacheBuffer(boolean useCache) {
        if (this.useCache || !OpenGlHelper.func_176075_f() || !Minecraft.func_71410_x().func_152345_ab()) {
            return this;
        }
        this.deleteCacheBuffer();
        if (useCache) {
            this.vertexBuffers = new VertexBuffer[BlockRenderLayer.values().length];
            for (int j = 0; j < BlockRenderLayer.values().length; ++j) {
                this.vertexBuffers[j] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            }
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
            this.cacheState.set(CacheState.NEED);
        }
        this.useCache = useCache;
        return this;
    }

    public WorldSceneRenderer deleteCacheBuffer() {
        if (this.useCache) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                    if (this.vertexBuffers[i] == null) continue;
                    this.vertexBuffers[i].func_177362_c();
                }
            });
            if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        this.tileEntities = null;
        this.useCache = false;
        this.cacheState.set(CacheState.UNUSED);
        return this;
    }

    public WorldSceneRenderer needCompileCache() {
        if (this.cacheState.get() == CacheState.COMPILING && this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        this.cacheState.set(CacheState.NEED);
        return this;
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setAfterWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.afterRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPos> blocks, ISceneRenderHook renderHook) {
        if (blocks != null) {
            this.renderedBlocksMap.put(blocks, renderHook);
        }
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<RayTraceResult> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public RayTraceResult getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(float x, float y, float width, float height, int mouseX, int mouseY) {
        Vector3f hitPos;
        RayTraceResult result;
        PositionedRect positionedRect = this.getPositionedRect((int)x, (int)y, (int)width, (int)height);
        PositionedRect mouse = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect.position.x && mouseX < positionedRect.position.x + positionedRect.size.width && mouseY > positionedRect.position.y && mouseY < positionedRect.position.y + positionedRect.size.height && (result = this.rayTrace(hitPos = this.unProject(mouseX, mouseY))) != null) {
            this.lastTraceResult = null;
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        this.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
        if (this.viewEntity != null) {
            Vector3 xzProduct = new Vector3(lookAt.x - eyePos.x, 0.0, lookAt.z - eyePos.z);
            double angleYaw = Math.toDegrees(xzProduct.angle(Vector3.Z));
            if (xzProduct.angle(Vector3.X) < 1.5707963267948966) {
                angleYaw = -angleYaw;
            }
            double anglePitch = Math.toDegrees(new Vector3((Tuple3f)lookAt).subtract(new Vector3((Tuple3f)eyePos)).angle(Vector3.Y)) - 90.0;
            this.viewEntity.func_70012_b(eyePos.x, eyePos.y, eyePos.z, (float)angleYaw, (float)anglePitch);
        }
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        Vector3 vecX = new Vector3(Math.cos(rotationPitch), 0.0, Math.sin(rotationPitch));
        Vector3 vecY = new Vector3(0.0, Math.tan(rotationYaw) * vecX.mag(), 0.0);
        Vector3 pos = vecX.copy().add(vecY).normalize().multiply(radius);
        this.setCameraLookAt(pos.add(lookAt.x, lookAt.y, lookAt.z).vector3f(), lookAt, this.worldUp);
    }

    protected PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    protected void setupCamera(PositionedRect positionedRect) {
        int x = positionedRect.getPosition().x;
        int y = positionedRect.getPosition().y;
        int width = positionedRect.getSize().width;
        int height = positionedRect.getSize().height;
        GlStateManager.func_179123_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179083_b((int)x, (int)y, (int)width, (int)height);
        this.clearView(x, y, width, height);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GLU.gluLookAt((float)this.eyePos.x, (float)this.eyePos.y, (float)this.eyePos.z, (float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z, (float)this.worldUp.x, (float)this.worldUp.y, (float)this.worldUp.z);
    }

    protected void clearView(int x, int y, int width, int height) {
        int i = (this.clearColor & 0xFF0000) >> 16;
        int j = (this.clearColor & 0xFF00) >> 8;
        int k = this.clearColor & 0xFF;
        GlStateManager.func_179082_a((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)(this.clearColor >> 24) / 255.0f));
        GlStateManager.func_179086_m((int)16640);
    }

    protected void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.func_179083_b((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
        GlStateManager.func_179099_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        boolean checkDisabledModel = this.world == mc.field_71441_e || this.world instanceof TrackedDummyWorld && ((TrackedDummyWorld)this.world).proxyWorld == mc.field_71441_e;
        float particleTicks = mc.func_184121_ak();
        if (this.useCache) {
            this.renderCacheBuffer(mc, oldRenderLayer, particleTicks, checkDisabledModel);
        } else {
            BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
            try {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    if (pass == 1) {
                        this.renderTESR(0, particleTicks, checkDisabledModel);
                    }
                    this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                        if (hook != null) {
                            hook.apply(false, pass, layer);
                        } else {
                            WorldSceneRenderer.setDefaultPassRenderState(pass);
                        }
                        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        this.renderBlocks(checkDisabledModel, blockrendererdispatcher, layer, buffer, (Collection<BlockPos>)renderedBlocks);
                        Tessellator.func_178181_a().func_78381_a();
                        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
                    });
                }
            }
            finally {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
            }
            this.renderTESR(1, particleTicks, checkDisabledModel);
        }
        GlStateManager.func_179103_j((int)7425);
        RenderHelper.func_74519_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    public boolean isCompiling() {
        return this.cacheState.get() == CacheState.COMPILING;
    }

    public double getCompileProgress() {
        if (this.maxProgress > 1000) {
            return (double)this.progress * 1.0 / (double)this.maxProgress;
        }
        return 0.0;
    }

    private void renderCacheBuffer(Minecraft mc, BlockRenderLayer oldRenderLayer, float particleTicks, boolean checkDisabledModel) {
        if (this.cacheState.get() == CacheState.NEED) {
            this.progress = 0;
            this.maxProgress = this.renderedBlocksMap.keySet().stream().map(Collection::size).reduce(0, Integer::sum) * (BlockRenderLayer.values().length + 1);
            this.thread = new Thread(() -> {
                this.cacheState.set(CacheState.COMPILING);
                BlockRendererDispatcher blockrendererdispatcher = mc.func_175602_ab();
                try {
                    for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                        BufferBuilder buffer = new BufferBuilder(262144);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        this.renderedBlocksMap.forEach((renderedBlocks, hook) -> this.renderBlocks(checkDisabledModel, blockrendererdispatcher, layer, buffer, (Collection<BlockPos>)renderedBlocks));
                        buffer.func_178965_a();
                        mc.func_152344_a(() -> this.vertexBuffers[layer.ordinal()].func_181722_a(buffer.func_178966_f()));
                    }
                }
                finally {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
                }
                HashSet<BlockPos> poses = new HashSet<BlockPos>();
                this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                    for (BlockPos pos : renderedBlocks) {
                        TileEntity tile;
                        ++this.progress;
                        if (Thread.interrupted()) {
                            return;
                        }
                        if (checkDisabledModel && MultiblockWorldSavedData.modelDisabled.contains(pos) || (tile = this.world.func_175625_s(pos)) == null || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile) == null) continue;
                        poses.add(pos);
                    }
                });
                if (Thread.interrupted()) {
                    return;
                }
                this.tileEntities = poses;
                this.cacheState.set(CacheState.COMPILED);
                this.thread = null;
                this.maxProgress = -1;
            });
            this.thread.start();
        } else {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                int pass;
                int n = pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
                if (pass == 1) {
                    this.renderTESR(0, particleTicks, checkDisabledModel);
                }
                GlStateManager.func_187410_q((int)32884);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_187410_q((int)32888);
                OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                GlStateManager.func_187410_q((int)32886);
                VertexBuffer vbo = this.vertexBuffers[layer.ordinal()];
                WorldSceneRenderer.setDefaultPassRenderState(pass);
                vbo.func_177359_a();
                this.setupArrayPointers();
                vbo.func_177358_a(7);
                OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
                GlStateManager.func_179117_G();
                for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                    VertexFormatElement.EnumUsage enumUsage = vertexformatelement.func_177375_c();
                    int k1 = vertexformatelement.func_177369_e();
                    switch (enumUsage) {
                        case POSITION: {
                            GlStateManager.func_187429_p((int)32884);
                            break;
                        }
                        case UV: {
                            OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + k1));
                            GlStateManager.func_187429_p((int)32888);
                            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                            break;
                        }
                        case COLOR: {
                            GlStateManager.func_187429_p((int)32886);
                            GlStateManager.func_179117_G();
                        }
                    }
                }
            }
            this.renderTESR(1, particleTicks, checkDisabledModel);
        }
    }

    private void renderBlocks(boolean checkDisabledModel, BlockRendererDispatcher blockrendererdispatcher, BlockRenderLayer layer, BufferBuilder buffer, Collection<BlockPos> renderedBlocks) {
        for (BlockPos pos : renderedBlocks) {
            IBlockState state;
            Block block;
            if (this.maxProgress > 0) {
                ++this.progress;
            }
            if (checkDisabledModel && MultiblockWorldSavedData.modelDisabled.contains(pos) || (block = (state = this.world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150350_a || !block.canRenderInLayer(state = state.func_185899_b((IBlockAccess)this.world, pos), layer)) continue;
            blockrendererdispatcher.func_175018_a(state, pos, (IBlockAccess)this.world, buffer);
        }
    }

    private void setupArrayPointers() {
        GlStateManager.func_187420_d((int)3, (int)5126, (int)28, (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)28, (int)12);
        GlStateManager.func_187405_c((int)2, (int)5126, (int)28, (int)16);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_187405_c((int)2, (int)5122, (int)28, (int)24);
        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
    }

    private void renderTESR(int pass, float particle, boolean checkDisabledModel) {
        if (this.particleManager != null) {
            this.particleManager.renderParticles(pass == 0, this.viewEntity, particle);
        }
        RenderHelper.func_74519_b();
        ForgeHooksClient.setRenderPass((int)pass);
        if (!this.useCache) {
            this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                if (hook != null) {
                    hook.apply(true, pass, null);
                } else {
                    WorldSceneRenderer.setDefaultPassRenderState(pass);
                }
                for (BlockPos pos : renderedBlocks) {
                    TileEntity tile;
                    if (checkDisabledModel && MultiblockWorldSavedData.modelDisabled.contains(pos) || (tile = this.world.func_175625_s(pos)) == null || !tile.shouldRenderInPass(pass)) continue;
                    TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), particle);
                }
            });
        } else if (this.tileEntities != null) {
            for (BlockPos pos : this.tileEntities) {
                TileEntity tile = this.world.func_175625_s(pos);
                if (tile == null || !tile.shouldRenderInPass(pass)) continue;
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), particle);
            }
        }
        ForgeHooksClient.setRenderPass((int)-1);
        RenderHelper.func_74518_a();
    }

    public static void setDefaultPassRenderState(int pass) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pass == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179103_j((int)7424);
        } else {
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179103_j((int)7425);
        }
    }

    public RayTraceResult rayTrace(Vector3f hitPos) {
        Vec3d startPos = new Vec3d((double)this.eyePos.x, (double)this.eyePos.y, (double)this.eyePos.z);
        hitPos.scale(2.0f);
        Vec3d endPos = new Vec3d((double)hitPos.x - startPos.field_72450_a, (double)hitPos.y - startPos.field_72448_b, (double)hitPos.z - startPos.field_72449_c);
        return this.world.func_72933_a(startPos, endPos);
    }

    public Vector3f project(BlockPos pos) {
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluProject((float)((float)pos.func_177958_n() + 0.5f), (float)((float)pos.func_177956_o() + 0.5f), (float)((float)pos.func_177952_p() + 0.5f), (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public Vector3f unProject(int mouseX, int mouseY) {
        GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject((float)mouseX, (float)mouseY, (float)pixelDepth, (FloatBuffer)MODELVIEW_MATRIX_BUFFER, (FloatBuffer)PROJECTION_MATRIX_BUFFER, (IntBuffer)VIEWPORT_BUFFER, (FloatBuffer)OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }

    protected RayTraceResult screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        GlStateManager.func_179126_j();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = this.unProject(mouseX, mouseY);
        RayTraceResult result = this.rayTrace(hitPos);
        this.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth, int x, int y, int width, int height) {
        GlStateManager.func_179126_j();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = this.project(pos);
        this.resetCamera();
        return winPos;
    }

    static enum CacheState {
        UNUSED,
        NEED,
        COMPILING,
        COMPILED;

    }
}

