/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.scene;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.client.renderer.scene.WorldSceneRenderer;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FBOWorldSceneRenderer
extends WorldSceneRenderer {
    private int resolutionWidth = 1080;
    private int resolutionHeight = 1080;
    private Framebuffer fbo;

    public FBOWorldSceneRenderer(World world, int resolutionWidth, int resolutionHeight) {
        super(world);
        this.setFBOSize(resolutionWidth, resolutionHeight);
    }

    public FBOWorldSceneRenderer(World world, Framebuffer fbo) {
        super(world);
        this.fbo = fbo;
    }

    public int getResolutionWidth() {
        return this.resolutionWidth;
    }

    public int getResolutionHeight() {
        return this.resolutionHeight;
    }

    public void setFBOSize(int resolutionWidth, int resolutionHeight) {
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.releaseFBO();
        try {
            this.fbo = new Framebuffer(resolutionWidth, resolutionHeight, true);
        }
        catch (Exception e) {
            Multiblocked.LOGGER.error((Object)e);
        }
    }

    public RayTraceResult screenPos2BlockPosFace(int mouseX, int mouseY) {
        int lastID = this.bindFBO();
        RayTraceResult looking = super.screenPos2BlockPosFace(mouseX, mouseY, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return looking;
    }

    public Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth) {
        int lastID = this.bindFBO();
        Vector3f winPos = super.blockPos2ScreenPos(pos, depth, 0, 0, this.resolutionWidth, this.resolutionHeight);
        this.unbindFBO(lastID);
        return winPos;
    }

    public void render(float x, float y, float width, float height, float mouseX, float mouseY) {
        int lastID = this.bindFBO();
        super.render(0.0f, 0.0f, this.resolutionWidth, this.resolutionHeight, (int)((float)this.resolutionWidth * (mouseX - x) / width), (int)((float)this.resolutionHeight * (1.0f - (mouseY - y) / height)));
        this.unbindFBO(lastID);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        lastID = GL11.glGetInteger((int)3553);
        GlStateManager.func_179144_i((int)this.fbo.field_147617_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179144_i((int)lastID);
    }

    @Override
    public void render(float x, float y, float width, float height, int mouseX, int mouseY) {
        this.render(x, y, width, height, (float)mouseX, (float)mouseY);
    }

    private int bindFBO() {
        int lastID = GL11.glGetInteger((int)36006);
        this.fbo.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.fbo.func_147614_f();
        this.fbo.func_147610_a(true);
        GlStateManager.func_179094_E();
        return lastID;
    }

    private void unbindFBO(int lastID) {
        GlStateManager.func_179121_F();
        this.fbo.func_147606_d();
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastID);
    }

    public void releaseFBO() {
        if (this.fbo != null) {
            this.fbo.func_147608_a();
        }
        this.fbo = null;
    }
}

