/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.particle.AbstractParticle;
import com.cleanroommc.multiblocked.client.particle.IParticle;
import com.cleanroommc.multiblocked.client.renderer.ICustomRenderer;
import com.cleanroommc.multiblocked.util.world.DummyWorld;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ParticleRenderer
implements ICustomRenderer {
    public boolean isBackLayer = true;
    public boolean isAddBlend;
    public int renderRange = -1;

    @SideOnly(value=Side.CLIENT)
    protected abstract AbstractParticle createParticle(ComponentTileEntity<?> var1, double var2, double var4, double var6);

    @Override
    public void renderItem(ItemStack stack) {
    }

    @Override
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        return false;
    }

    @Override
    public final void onPreAccess(TileEntity te) {
        if (te instanceof ComponentTileEntity) {
            ComponentTileEntity component = (ComponentTileEntity)te;
            BlockPos pos = te.func_174877_v();
            AbstractParticle particle = this.createParticle(component, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            component.rendererObject = particle;
            if (particle != null) {
                particle.setOnUpdate(p -> {
                    if (component.func_145837_r() || component.func_145831_w().func_175625_s(component.func_174877_v()) != component) {
                        p.kill();
                    }
                });
                particle.setImmortal();
                particle.addParticle();
                particle.setAddBlend(this.isAddBlend);
                particle.setBackLayer(this.isBackLayer);
                if (this.renderRange > 0) {
                    particle.setRenderRange(this.renderRange);
                }
            }
        }
    }

    @Override
    public final void onPostAccess(TileEntity te) {
        if (te instanceof ComponentTileEntity) {
            ComponentTileEntity component = (ComponentTileEntity)te;
            if (component.rendererObject instanceof AbstractParticle) {
                ((AbstractParticle)component.rendererObject).kill();
                component.rendererObject = null;
            }
        }
    }

    @Override
    public boolean shouldRenderInPass(World world, BlockPos pos, int pass) {
        TileEntity tileEntity;
        if (world instanceof DummyWorld && (tileEntity = world.func_175625_s(pos)) instanceof ComponentTileEntity && ((ComponentTileEntity)tileEntity).rendererObject instanceof IParticle) {
            IParticle particle = (IParticle)((ComponentTileEntity)tileEntity).rendererObject;
            return particle.isBackLayer() && pass == 0 || !particle.isBackLayer() && pass == 1;
        }
        return false;
    }

    @Override
    public boolean hasTESR(World world, BlockPos pos) {
        return world instanceof DummyWorld;
    }

    @Override
    public void renderTESR(@Nonnull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IParticle particle = null;
        if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).rendererObject instanceof IParticle) {
            particle = (IParticle)((ComponentTileEntity)te).rendererObject;
        }
        if (particle == null) {
            return;
        }
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        RenderHelper.func_74518_a();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        if (particle.isAddBlend()) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        particle.getGLHandler().preDraw(builder);
        particle.renderParticle(builder, partialTicks);
        particle.getGLHandler().postDraw(builder);
        if (particle.isAddBlend()) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderHelper.func_74519_b();
    }

    @Override
    public JsonObject toJson(Gson gson, JsonObject jsonObject) {
        jsonObject.addProperty("isBackLayer", Boolean.valueOf(this.isBackLayer));
        jsonObject.addProperty("isAddBlend", Boolean.valueOf(this.isAddBlend));
        jsonObject.addProperty("renderRange", (Number)this.renderRange);
        return jsonObject;
    }
}

