/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.model.ModelFactory;
import com.cleanroommc.multiblocked.client.model.custommodel.CustomBakedModel;
import com.cleanroommc.multiblocked.client.renderer.ICustomRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IModelRenderer
implements ICustomRenderer {
    public static final IModelRenderer INSTANCE = new IModelRenderer();
    protected static final Set<ResourceLocation> CACHE = new HashSet<ResourceLocation>();
    public final ResourceLocation modelLocation;
    @SideOnly(value=Side.CLIENT)
    protected IBakedModel itemModel;
    @SideOnly(value=Side.CLIENT)
    protected Map<EnumFacing, CustomBakedModel> blockModels;

    protected IModelRenderer() {
        this.modelLocation = null;
    }

    public IModelRenderer(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        if (Multiblocked.isClient()) {
            if (this.isRaw()) {
                this.registerTextureSwitchEvent();
                CACHE.add(modelLocation);
            }
            this.blockModels = new EnumMap<EnumFacing, CustomBakedModel>(EnumFacing.class);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected IModel getModel() {
        return ModelFactory.getModel(this.modelLocation);
    }

    @Override
    public void renderItem(ItemStack stack) {
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        ri.func_180454_a(stack, this.getItemBakedModel());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        CustomBakedModel model = this.getBlockBakedModel(pos, blockAccess);
        if (!model.shouldRenderInLayer(state, MathHelper.func_180186_a((Vec3i)pos))) {
            return false;
        }
        BlockModelRenderer blockModelRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        blockModelRenderer.func_178267_a(blockAccess, (IBakedModel)model, state, pos, buffer, true);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        BlockModelRenderer blockModelRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        IBakedModel bakedModel = ForgeHooksClient.getDamageModel((IBakedModel)this.getBlockBakedModel(pos, blockAccess), (TextureAtlasSprite)texture, (IBlockState)state, (IBlockAccess)blockAccess, (BlockPos)pos);
        blockModelRenderer.func_178267_a(blockAccess, bakedModel, state, pos, Tessellator.func_178181_a().func_178180_c(), true);
    }

    @SideOnly(value=Side.CLIENT)
    protected IBakedModel getItemBakedModel() {
        if (this.itemModel == null) {
            this.itemModel = this.getModel().bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        return this.itemModel;
    }

    @SideOnly(value=Side.CLIENT)
    protected CustomBakedModel getBlockBakedModel(BlockPos pos, IBlockAccess blockAccess) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        EnumFacing frontFacing = EnumFacing.NORTH;
        if (tileEntity instanceof ComponentTileEntity) {
            frontFacing = ((ComponentTileEntity)tileEntity).getFrontFacing();
        }
        return this.blockModels.computeIfAbsent(frontFacing, facing -> new CustomBakedModel(this.getModel().bake((IModelState)TRSRTransformation.from((EnumFacing)facing), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter())));
    }

    @Override
    public boolean isRaw() {
        return !CACHE.contains(this.modelLocation);
    }

    @Override
    public void onTextureSwitchEvent(TextureMap map) {
        this.blockModels.clear();
        this.itemModel = null;
        IModel model = this.getModel();
        for (ResourceLocation texture : model.getTextures()) {
            map.func_174942_a(texture);
        }
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        return this.getItemBakedModel().func_177554_e();
    }

    @Override
    public String getType() {
        return "imodel";
    }

    @Override
    public IRenderer fromJson(Gson gson, JsonObject jsonObject) {
        return new IModelRenderer((ResourceLocation)gson.fromJson(jsonObject.get("modelLocation"), ResourceLocation.class));
    }

    @Override
    public JsonObject toJson(Gson gson, JsonObject jsonObject) {
        jsonObject.add("modelLocation", gson.toJsonTree((Object)this.modelLocation, ResourceLocation.class));
        return jsonObject;
    }

    @Override
    public Supplier<IRenderer> createConfigurator(WidgetGroup parent, DraggableScrollableWidgetGroup group, IRenderer current) {
        TextFieldWidget tfw = new TextFieldWidget(1, 1, 150, 20, true, null, null);
        group.addWidget(tfw);
        File path = new File(Multiblocked.location, "assets/multiblocked/models");
        group.addWidget(new ButtonWidget(155, 1, 20, 20, cd -> DialogWidget.showFileDialog(parent, "select a java model", path, true, DialogWidget.suffixFilter(".json"), r -> {
            if (r != null && r.isFile()) {
                tfw.setCurrentString("multiblocked:" + r.getPath().replace(path.getPath(), "").substring(1).replace(".json", "").replace('\\', '/'));
            }
        })).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("F", -1)).setHoverTooltip("multiblocked.gui.tips.file_selector"));
        if (current instanceof IModelRenderer && ((IModelRenderer)current).modelLocation != null) {
            tfw.setCurrentString(((IModelRenderer)current).modelLocation.toString());
        }
        return () -> {
            if (tfw.getCurrentString().isEmpty()) {
                return null;
            }
            return new IModelRenderer(new ResourceLocation(tfw.getCurrentString()));
        };
    }
}

