/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.texture.TextTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DialogWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.TextFieldWidget;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.ICustomRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.geo.render.built.GeoQuad;
import software.bernie.geckolib3.geo.render.built.GeoVertex;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.resource.GeckoLibCache;

public class GeoComponentRenderer
extends AnimatedGeoModel<ComponentFactory>
implements ICustomRenderer,
IGeoRenderer<ComponentFactory> {
    public static final GeoComponentRenderer INSTANCE = new GeoComponentRenderer(null, false);
    public final String modelName;
    public final boolean isGlobal;
    @SideOnly(value=Side.CLIENT)
    private ComponentFactory itemFactory;

    public GeoComponentRenderer(String modelName, boolean isGlobal) {
        this.modelName = modelName;
        this.isGlobal = isGlobal;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(ItemStack stack) {
        if (this.itemFactory == null) {
            this.itemFactory = new ComponentFactory(null, this);
        }
        GeoModel model = this.getModel(this.getModelLocation(this.itemFactory));
        this.setLivingAnimations(this.itemFactory, this.getUniqueID(this.itemFactory));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.01f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(this.itemFactory));
        this.render(model, this.itemFactory, Minecraft.func_71410_x().func_184121_ak(), 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(World world, BlockPos pos, int pass) {
        return true;
    }

    @Override
    public boolean isGlobalRenderer(@Nonnull TileEntity te) {
        return this.isGlobal;
    }

    @Override
    public String getType() {
        return "geo";
    }

    @Override
    public IRenderer fromJson(Gson gson, JsonObject jsonObject) {
        return new GeoComponentRenderer(jsonObject.get("modelName").getAsString(), JsonUtils.func_151209_a((JsonObject)jsonObject, (String)"isGlobal", (boolean)false));
    }

    @Override
    public JsonObject toJson(Gson gson, JsonObject jsonObject) {
        jsonObject.addProperty("modelName", this.modelName);
        if (this.isGlobal) {
            jsonObject.addProperty("isGlobal", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    @Override
    public Supplier<IRenderer> createConfigurator(WidgetGroup parent, DraggableScrollableWidgetGroup group, IRenderer current) {
        TextFieldWidget tfw = new TextFieldWidget(1, 1, 150, 20, true, null, null);
        File path = new File(Multiblocked.location, "assets/multiblocked/geo");
        AtomicBoolean isGlobal = new AtomicBoolean(false);
        if (current instanceof GeoComponentRenderer) {
            tfw.setCurrentString(((GeoComponentRenderer)current).modelName);
            isGlobal.set(((GeoComponentRenderer)current).isGlobal);
        }
        group.addWidget(new ButtonWidget(155, 1, 20, 20, cd -> DialogWidget.showFileDialog(parent, "select a geo file", path, true, DialogWidget.suffixFilter(".geo.json"), r -> {
            if (r != null && r.isFile()) {
                tfw.setCurrentString(r.getName().replace(".geo.json", ""));
            }
        })).setButtonTexture(new ResourceTexture("multiblocked:textures/gui/darkened_slot.png"), new TextTexture("F", -1)).setHoverTooltip("multiblocked.gui.tips.file_selector"));
        group.addWidget(tfw);
        group.addWidget(this.createBoolSwitch(1, 25, "isGlobal", "multiblocked.gui.predicate.geo.0", isGlobal.get(), isGlobal::set));
        return () -> {
            if (tfw.getCurrentString().isEmpty()) {
                return null;
            }
            return new GeoComponentRenderer(tfw.getCurrentString(), isGlobal.get());
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isRaw() {
        return !GeckoLibCache.getInstance().getGeoModels().containsKey(this.getModelLocation(null));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasTESR(World world, BlockPos pos) {
        return true;
    }

    @Override
    public void onPreAccess(TileEntity te) {
        if (te instanceof ComponentTileEntity) {
            ComponentTileEntity component = (ComponentTileEntity)te;
            component.rendererObject = new ComponentFactory(component, this);
        }
    }

    @Override
    public void onPostAccess(TileEntity te) {
        if (te instanceof ComponentTileEntity) {
            ComponentTileEntity component = (ComponentTileEntity)te;
            component.rendererObject = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTESR(@Nonnull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te instanceof ComponentTileEntity && ((ComponentTileEntity)te).rendererObject instanceof ComponentFactory) {
            ComponentTileEntity controller = (ComponentTileEntity)te;
            ComponentFactory factory = (ComponentFactory)controller.rendererObject;
            GeoModel model = this.getModel(this.getModelLocation(factory));
            this.setLivingAnimations(factory, this.getUniqueID(factory));
            int light = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
            int lx = light % 65536;
            int ly = light / 65536;
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            OpenGlHelper.func_77475_a((int)3553, (float)lx, (float)ly);
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179109_b((float)0.0f, (float)0.01f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            this.rotateBlock(controller.getFrontFacing());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(factory));
            this.render(model, factory, partialTicks, 1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecursively(BufferBuilder builder, GeoBone bone, float red, float green, float blue, float alpha) {
        int pass;
        boolean isEmissive = bone.name.equals("emissive");
        float lastBrightnessX = 0.0f;
        float lastBrightnessY = 0.0f;
        if (isEmissive) {
            Tessellator.func_178181_a().func_78381_a();
            lastBrightnessX = OpenGlHelper.lastBrightnessX;
            lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            builder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        }
        if ((pass = MinecraftForgeClient.getRenderPass()) < 0) {
            this.rawRenderRecursively(builder, bone, red, green, blue, alpha);
        }
        boolean isTranslucent = bone.name.equals("translucent");
        if (pass == 1 && isTranslucent) {
            this.rawRenderRecursively(builder, bone, red, green, blue, alpha);
        } else if (pass == 0 && !isTranslucent) {
            MATRIX_STACK.push();
            MATRIX_STACK.translate(bone);
            MATRIX_STACK.moveToPivot(bone);
            MATRIX_STACK.rotate(bone);
            MATRIX_STACK.scale(bone);
            MATRIX_STACK.moveBackFromPivot(bone);
            if (!bone.isHidden) {
                for (GeoCube cube : bone.childCubes) {
                    MATRIX_STACK.push();
                    GlStateManager.func_179094_E();
                    this.renderCube(builder, cube, red, green, blue, alpha);
                    GlStateManager.func_179121_F();
                    MATRIX_STACK.pop();
                }
                for (GeoBone childBone : bone.childBones) {
                    this.renderRecursively(builder, childBone, red, green, blue, alpha);
                }
            }
            MATRIX_STACK.pop();
        } else if (pass == 1) {
            MATRIX_STACK.push();
            MATRIX_STACK.translate(bone);
            MATRIX_STACK.moveToPivot(bone);
            MATRIX_STACK.rotate(bone);
            MATRIX_STACK.scale(bone);
            MATRIX_STACK.moveBackFromPivot(bone);
            if (!bone.isHidden) {
                for (GeoBone childBone : bone.childBones) {
                    this.renderRecursively(builder, childBone, red, green, blue, alpha);
                }
            }
            MATRIX_STACK.pop();
        }
        if (isEmissive) {
            Tessellator.func_178181_a().func_78381_a();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
            builder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        }
    }

    public void renderCube(BufferBuilder builder, GeoCube cube, float red, float green, float blue, float alpha) {
        MATRIX_STACK.moveToPivot(cube);
        MATRIX_STACK.rotate(cube);
        MATRIX_STACK.moveBackFromPivot(cube);
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            Vector3f normal = new Vector3f((float)quad.normal.func_177958_n(), (float)quad.normal.func_177956_o(), (float)quad.normal.func_177952_p());
            MATRIX_STACK.getNormalMatrix().transform((Tuple3f)normal);
            if ((cube.size.y == 0.0f || cube.size.z == 0.0f) && normal.getX() < 0.0f) {
                normal.x *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.z == 0.0f) && normal.getY() < 0.0f) {
                normal.y *= -1.0f;
            }
            if ((cube.size.x == 0.0f || cube.size.y == 0.0f) && normal.getZ() < 0.0f) {
                normal.z *= -1.0f;
            }
            for (GeoVertex vertex : quad.vertices) {
                Vector4f vector4f = new Vector4f(vertex.position.getX(), vertex.position.getY(), vertex.position.getZ(), 1.0f);
                MATRIX_STACK.getModelMatrix().transform((Tuple4f)vector4f);
                builder.func_181662_b((double)vector4f.getX(), (double)vector4f.getY(), (double)vector4f.getZ()).func_187315_a((double)vertex.textureU, (double)vertex.textureV).func_181666_a(red, green, blue, alpha).func_181663_c(normal.getX(), normal.getY(), normal.getZ()).func_181675_d();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void rawRenderRecursively(BufferBuilder builder, GeoBone bone, float red, float green, float blue, float alpha) {
        MATRIX_STACK.push();
        MATRIX_STACK.translate(bone);
        MATRIX_STACK.moveToPivot(bone);
        MATRIX_STACK.rotate(bone);
        MATRIX_STACK.scale(bone);
        MATRIX_STACK.moveBackFromPivot(bone);
        if (!bone.isHidden) {
            for (GeoCube cube : bone.childCubes) {
                MATRIX_STACK.push();
                GlStateManager.func_179094_E();
                this.renderCube(builder, cube, red, green, blue, alpha);
                GlStateManager.func_179121_F();
                MATRIX_STACK.pop();
            }
            for (GeoBone childBone : bone.childBones) {
                this.rawRenderRecursively(builder, childBone, red, green, blue, alpha);
            }
        }
        MATRIX_STACK.pop();
    }

    @SideOnly(value=Side.CLIENT)
    protected void rotateBlock(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public ResourceLocation getAnimationFileLocation(ComponentFactory entity) {
        return new ResourceLocation("multiblocked", String.format("animations/%s.animation.json", this.modelName));
    }

    public ResourceLocation getModelLocation(ComponentFactory animatable) {
        return new ResourceLocation("multiblocked", String.format("geo/%s.geo.json", this.modelName));
    }

    public ResourceLocation getTextureLocation(ComponentFactory entity) {
        return new ResourceLocation("multiblocked", String.format("textures/%s.png", this.modelName));
    }

    public GeoModelProvider<?> getGeoModelProvider() {
        return this;
    }

    static {
        if (Multiblocked.isClient()) {
            AnimationController.addModelFetcher(object -> {
                if (object instanceof ComponentFactory) {
                    ComponentFactory factory = (ComponentFactory)object;
                    return (IAnimatableModel)factory.renderer.getGeoModelProvider();
                }
                return null;
            });
        }
    }

    public static class ComponentFactory
    implements IAnimatable {
        public final ComponentTileEntity<?> component;
        public final GeoComponentRenderer renderer;
        public AnimationFile animationFile;
        public String currentStatus;
        private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

        public ComponentFactory(ComponentTileEntity<?> component, GeoComponentRenderer renderer) {
            this.component = component;
            this.renderer = renderer;
        }

        private PlayState predicate(AnimationEvent<ComponentFactory> event) {
            if (this.animationFile == null) {
                this.animationFile = (AnimationFile)GeckoLibCache.getInstance().getAnimations().get(this.renderer.getAnimationFileLocation(this));
            }
            if (this.animationFile == null) {
                return PlayState.STOP;
            }
            AnimationController controller = event.getController();
            String lastStatus = this.currentStatus;
            String string = this.currentStatus = this.component == null ? "unformed" : this.component.getStatus();
            if (!Objects.equals(lastStatus, this.currentStatus)) {
                Animation trans;
                if (this.currentStatus == null) {
                    return PlayState.STOP;
                }
                AnimationBuilder animationBuilder = new AnimationBuilder();
                if (lastStatus != null && (trans = this.animationFile.getAnimation(lastStatus + "-" + this.currentStatus)) != null) {
                    animationBuilder.addAnimation(trans.animationName);
                }
                if (this.animationFile.getAnimation(this.currentStatus) != null) {
                    animationBuilder.addAnimation(this.currentStatus);
                }
                controller.setAnimation(animationBuilder);
            }
            return PlayState.CONTINUE;
        }

        public void registerControllers(AnimationData data) {
            data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        }

        public AnimationFactory getFactory() {
            return this.factory;
        }
    }
}

