/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.texture.ColorBorderTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ColorRectTexture;
import com.cleanroommc.multiblocked.api.gui.texture.GuiTextureGroup;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ButtonWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.blueprint_table.dialogs.ResourceTextureWidget;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.api.tile.part.PartTileEntity;
import com.cleanroommc.multiblocked.client.model.ModelFactory;
import com.cleanroommc.multiblocked.client.model.custommodel.CustomBakedModel;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.client.renderer.impl.IModelRenderer;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GTRenderer
extends IModelRenderer {
    public static final GTRenderer INSTANCE = new GTRenderer();
    public ResourceLocation baseTexture = new ResourceLocation("multiblocked:blocks/gregtech_base");
    public ResourceLocation frontOverlay = new ResourceLocation("multiblocked:blocks/gregtech_front");
    public ResourceLocation backOverlay;
    public ResourceLocation leftOverlay;
    public ResourceLocation rightOverlay;
    public ResourceLocation upOverlay;
    public ResourceLocation downOverlay;
    public boolean formedAsController;

    private GTRenderer() {
    }

    public GTRenderer(ResourceLocation baseTexture, ResourceLocation ... frontOverlay) {
        this.baseTexture = baseTexture;
        if (frontOverlay.length > 0) {
            this.frontOverlay = frontOverlay[0];
        }
        if (frontOverlay.length > 1) {
            this.backOverlay = frontOverlay[1];
        }
        if (frontOverlay.length > 2) {
            this.leftOverlay = frontOverlay[2];
        }
        if (frontOverlay.length > 3) {
            this.rightOverlay = frontOverlay[3];
        }
        if (frontOverlay.length > 4) {
            this.upOverlay = frontOverlay[4];
        }
        if (frontOverlay.length > 5) {
            this.downOverlay = frontOverlay[5];
        }
        if (Multiblocked.isClient()) {
            this.registerTextureSwitchEvent();
            this.blockModels = new EnumMap(EnumFacing.class);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getType() {
        return "gregtech";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isRaw() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (this.formedAsController && te instanceof PartTileEntity) {
            PartTileEntity part = (PartTileEntity)te;
            List<ControllerTileEntity> controllers = part.getControllers();
            for (ControllerTileEntity controller : controllers) {
                if (!controller.isFormed() || !(controller.getRenderer() instanceof GTRenderer)) continue;
                CustomBakedModel model = new CustomBakedModel(this.getModel(((GTRenderer)controller.getRenderer()).baseTexture).bake((IModelState)TRSRTransformation.from((EnumFacing)part.getFrontFacing()), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter()));
                if (!model.shouldRenderInLayer(state, MathHelper.func_180186_a((Vec3i)pos))) {
                    return false;
                }
                BlockModelRenderer blockModelRenderer = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
                blockModelRenderer.func_178267_a(blockAccess, (IBakedModel)model, state, pos, buffer, true);
                return true;
            }
        }
        return super.renderBlock(state, pos, blockAccess, buffer);
    }

    @SideOnly(value=Side.CLIENT)
    protected IModel getModel(ResourceLocation baseTexture) {
        ModelFactory factory = new ModelFactory(ModelFactory.ModelTemplate.CUBE_2_LAYER).addSprite("bot_down", baseTexture).addSprite("bot_up", baseTexture).addSprite("bot_north", baseTexture).addSprite("bot_south", baseTexture).addSprite("bot_west", baseTexture).addSprite("bot_east", baseTexture).addSprite("top_north", this.frontOverlay);
        if (this.backOverlay != null) {
            factory.addSprite("top_south", this.backOverlay);
        }
        if (this.leftOverlay != null) {
            factory.addSprite("top_west", this.leftOverlay);
        }
        if (this.rightOverlay != null) {
            factory.addSprite("top_east", this.rightOverlay);
        }
        if (this.upOverlay != null) {
            factory.addSprite("top_up", this.upOverlay);
        }
        if (this.downOverlay != null) {
            factory.addSprite("top_down", this.downOverlay);
        }
        return factory.getMappedModel();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IModel getModel() {
        return this.getModel(this.baseTexture);
    }

    @Override
    public JsonObject toJson(Gson gson, JsonObject jsonObject) {
        jsonObject.add("baseTexture", gson.toJsonTree((Object)this.baseTexture, ResourceLocation.class));
        jsonObject.add("frontTexture", gson.toJsonTree((Object)this.frontOverlay, ResourceLocation.class));
        if (this.backOverlay != null) {
            jsonObject.add("backTexture", gson.toJsonTree((Object)this.backOverlay, ResourceLocation.class));
        }
        if (this.leftOverlay != null) {
            jsonObject.add("leftTexture", gson.toJsonTree((Object)this.leftOverlay, ResourceLocation.class));
        }
        if (this.rightOverlay != null) {
            jsonObject.add("rightTexture", gson.toJsonTree((Object)this.rightOverlay, ResourceLocation.class));
        }
        if (this.upOverlay != null) {
            jsonObject.add("upTexture", gson.toJsonTree((Object)this.upOverlay, ResourceLocation.class));
        }
        if (this.downOverlay != null) {
            jsonObject.add("downTexture", gson.toJsonTree((Object)this.downOverlay, ResourceLocation.class));
        }
        if (this.formedAsController) {
            jsonObject.addProperty("formedAsController", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    @Override
    public IRenderer fromJson(Gson gson, JsonObject jsonObject) {
        GTRenderer renderer = new GTRenderer((ResourceLocation)gson.fromJson(jsonObject.get("baseTexture"), ResourceLocation.class), (ResourceLocation)gson.fromJson(jsonObject.get("frontTexture"), ResourceLocation.class));
        if (jsonObject.has("backTexture")) {
            renderer.backOverlay = (ResourceLocation)gson.fromJson(jsonObject.get("backTexture"), ResourceLocation.class);
        }
        if (jsonObject.has("leftTexture")) {
            renderer.leftOverlay = (ResourceLocation)gson.fromJson(jsonObject.get("leftTexture"), ResourceLocation.class);
        }
        if (jsonObject.has("rightTexture")) {
            renderer.rightOverlay = (ResourceLocation)gson.fromJson(jsonObject.get("rightTexture"), ResourceLocation.class);
        }
        if (jsonObject.has("upTexture")) {
            renderer.upOverlay = (ResourceLocation)gson.fromJson(jsonObject.get("upTexture"), ResourceLocation.class);
        }
        if (jsonObject.has("downTexture")) {
            renderer.downOverlay = (ResourceLocation)gson.fromJson(jsonObject.get("downTexture"), ResourceLocation.class);
        }
        if (jsonObject.has("formedAsController")) {
            renderer.formedAsController = jsonObject.get("formedAsController").getAsBoolean();
        }
        return renderer;
    }

    @Override
    public Supplier<IRenderer> createConfigurator(WidgetGroup parent, DraggableScrollableWidgetGroup group, IRenderer current) {
        GTRenderer renderer = new GTRenderer();
        if (current instanceof GTRenderer) {
            renderer.formedAsController = ((GTRenderer)current).formedAsController;
            renderer.baseTexture = ((GTRenderer)current).baseTexture;
            renderer.frontOverlay = ((GTRenderer)current).frontOverlay;
            renderer.backOverlay = ((GTRenderer)current).backOverlay;
            renderer.leftOverlay = ((GTRenderer)current).leftOverlay;
            renderer.rightOverlay = ((GTRenderer)current).rightOverlay;
            renderer.upOverlay = ((GTRenderer)current).upOverlay;
            renderer.downOverlay = ((GTRenderer)current).downOverlay;
        }
        this.addTextureSelector(1, 1, 60, 60, "base texture", parent, group, renderer.baseTexture, r -> {
            renderer.baseTexture = r;
        });
        this.addTextureSelector(65, 1, 30, 30, "front overlay", parent, group, renderer.frontOverlay, r -> {
            renderer.frontOverlay = r;
        });
        this.addTextureSelector(99, 1, 30, 30, "back overlay", parent, group, renderer.backOverlay, r -> {
            renderer.backOverlay = r;
        });
        this.addTextureSelector(133, 1, 30, 30, "left overlay", parent, group, renderer.leftOverlay, r -> {
            renderer.leftOverlay = r;
        });
        this.addTextureSelector(65, 34, 30, 30, "right overlay", parent, group, renderer.rightOverlay, r -> {
            renderer.rightOverlay = r;
        });
        this.addTextureSelector(99, 34, 30, 30, "up overlay", parent, group, renderer.upOverlay, r -> {
            renderer.upOverlay = r;
        });
        this.addTextureSelector(133, 34, 30, 30, "down overlay", parent, group, renderer.downOverlay, r -> {
            renderer.downOverlay = r;
        });
        group.addWidget(this.createBoolSwitch(1, 70, "formedAsController", "When the multi formed, if its true and the controller also uses the GregTech Model, it will change the base texture to the controller\u00e2\u20ac\u2122s base texture.", renderer.formedAsController, r -> {
            renderer.formedAsController = r;
        }));
        return () -> {
            GTRenderer result = new GTRenderer(renderer.baseTexture, renderer.frontOverlay);
            result.backOverlay = renderer.backOverlay;
            result.leftOverlay = renderer.leftOverlay;
            result.rightOverlay = renderer.rightOverlay;
            result.upOverlay = renderer.upOverlay;
            result.downOverlay = renderer.downOverlay;
            result.formedAsController = renderer.formedAsController;
            return result;
        };
    }

    protected void addTextureSelector(int x, int y, int width, int height, String text, WidgetGroup parent, WidgetGroup group, ResourceLocation init, Consumer<ResourceLocation> newTexture) {
        ImageWidget imageWidget = init != null ? new ImageWidget(x, y, width, height, new GuiTextureGroup(new ColorBorderTexture(1, -1), new ResourceTexture(init.func_110624_b() + ":textures/" + init.func_110623_a() + ".png"))) : new ImageWidget(x, y, width, height, new ColorBorderTexture(1, -1));
        group.addWidget(imageWidget);
        group.addWidget(new ButtonWidget(x, y, width, height, null, cd -> new ResourceTextureWidget(parent, texture -> {
            if (texture != null) {
                imageWidget.setImage(new GuiTextureGroup(new ColorBorderTexture(1, -1), (IGuiTexture)texture));
                newTexture.accept(new ResourceLocation(texture.imageLocation.toString().replace("textures/", "").replace(".png", "")));
            }
        })).setHoverTexture(new ColorRectTexture(0x4FAAAAAA)).setHoverTooltip(String.format("select the %s texture", text)));
    }
}

