/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.client.renderer.impl.BlockStateRenderer;
import com.cleanroommc.multiblocked.client.util.FacadeBlockWorld;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CycleBlockStateRenderer
extends BlockStateRenderer {
    public final BlockInfo[] blockInfos;
    public int index;
    public long lastTime;

    @Override
    public String getType() {
        return "cycleblockstate";
    }

    public CycleBlockStateRenderer(BlockInfo[] blockInfos) {
        super(Blocks.field_150350_a.func_176223_P());
        if (blockInfos.length == 0) {
            blockInfos = new BlockInfo[]{new BlockInfo(Blocks.field_150350_a)};
        }
        this.blockInfos = blockInfos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IBakedModel getItemModel(ItemStack renderItem) {
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(renderItem, null, null);
    }

    @Override
    public BlockInfo getBlockInfo() {
        long time = System.currentTimeMillis();
        if (time - this.lastTime > 1000L) {
            this.lastTime = time;
            this.index = Multiblocked.RNG.nextInt();
        }
        return this.blockInfos[Math.abs(this.index) % this.blockInfos.length];
    }

    @Override
    public IBlockState getState() {
        return this.getBlockInfo().getBlockState();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTESR(@Nonnull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = this.getState();
        TileEntity tileEntity = this.getBlockInfo().getTileEntity();
        int pass = MinecraftForgeClient.getRenderPass();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        FacadeBlockWorld dummyWorld = new FacadeBlockWorld(te.func_145831_w(), te.func_174877_v(), this.getState(), tileEntity);
        if (tileEntity != null) {
            tileEntity.func_145834_a((World)dummyWorld);
            tileEntity.func_174878_a(te.func_174877_v());
        }
        BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (pass == 0 && layer == BlockRenderLayer.TRANSLUCENT || pass == 1 && layer != BlockRenderLayer.TRANSLUCENT || !state.func_177230_c().canRenderInLayer(state, layer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            if (state.func_177230_c() instanceof BlockComponent) {
                IRenderer renderer = ((BlockComponent)state.func_177230_c()).definition.getRenderer();
                if (renderer != null) {
                    renderer.renderBlock(state, te.func_174877_v(), (IBlockAccess)dummyWorld, buffer);
                }
            } else {
                brd.func_175018_a(state, te.func_174877_v(), (IBlockAccess)dummyWorld, buffer);
            }
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179103_j((int)7425);
        RenderHelper.func_74519_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
        if (tileEntity == null) {
            return;
        }
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147546_a(tileEntity.getClass());
        if (tesr != null) {
            tesr.func_192841_a(tileEntity, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    @Override
    public boolean shouldRenderInPass(World world, BlockPos pos, int pass) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasTESR(World world, BlockPos pos) {
        return true;
    }
}

