/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer.impl;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.BlockSelectorWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.DraggableScrollableWidgetGroup;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.client.renderer.ICustomRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.client.util.FacadeBlockAccess;
import com.cleanroommc.multiblocked.client.util.FacadeBlockWorld;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateRenderer
implements ICustomRenderer {
    public static final BlockStateRenderer INSTANCE = new BlockStateRenderer();
    public final BlockInfo blockInfo;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel itemModel;

    private BlockStateRenderer() {
        this.blockInfo = null;
    }

    public BlockStateRenderer(IBlockState state) {
        this(BlockInfo.fromBlockState(state == null ? Blocks.field_180401_cv.func_176223_P() : state));
    }

    public BlockStateRenderer(BlockInfo blockInfo) {
        BlockInfo blockInfo2 = this.blockInfo = blockInfo == null ? new BlockInfo(Blocks.field_180401_cv) : blockInfo;
        if (Multiblocked.isClient()) {
            this.registerTextureSwitchEvent();
        }
    }

    public IBlockState getState() {
        return this.blockInfo.getBlockState();
    }

    public BlockInfo getBlockInfo() {
        return this.blockInfo;
    }

    @SideOnly(value=Side.CLIENT)
    protected IBakedModel getItemModel(ItemStack renderItem) {
        if (this.itemModel == null) {
            this.itemModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(renderItem, null, null);
        }
        return this.itemModel;
    }

    @Override
    public void renderItem(ItemStack stack) {
        IBlockState state = this.getState();
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        ItemStack renderItem = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_180651_a(state));
        ri.func_180454_a(renderItem, this.getItemModel(renderItem));
    }

    @Override
    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        state = this.getState();
        if (state.func_177230_c().canRenderInLayer(state, MinecraftForgeClient.getRenderLayer())) {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            FacadeBlockAccess access = new FacadeBlockAccess(blockAccess, pos, state, blockAccess instanceof World ? this.getTileEntity((World)blockAccess, pos) : this.blockInfo.getTileEntity());
            brd.func_175020_a(state, pos, texture, (IBlockAccess)access);
        }
    }

    @Override
    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        state = this.getState();
        if (state.func_177230_c().canRenderInLayer(state, MinecraftForgeClient.getRenderLayer())) {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            FacadeBlockAccess access = new FacadeBlockAccess(blockAccess, pos, state, blockAccess instanceof World ? this.getTileEntity((World)blockAccess, pos) : this.blockInfo.getTileEntity());
            return brd.func_175018_a(state, pos, (IBlockAccess)access, buffer);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasTESR(World world, BlockPos pos) {
        TileEntity tileEntity = this.getTileEntity(world, pos);
        if (tileEntity == null) {
            return false;
        }
        return TileEntityRendererDispatcher.field_147556_a.func_147546_a(tileEntity.getClass()) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntity getTileEntity(World world, BlockPos pos) {
        BlockInfo blockInfo = this.getBlockInfo();
        TileEntity tile = blockInfo.getTileEntity();
        if (tile != null) {
            try {
                tile.func_145834_a((World)new FacadeBlockWorld(world, pos, this.getState(), tile));
                tile.func_174878_a(pos);
            }
            catch (Throwable throwable) {
                blockInfo.setTileEntity(null);
            }
        }
        return tile;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderInPass(World world, BlockPos pos, int pass) {
        TileEntity tileEntity = this.getTileEntity(world, pos);
        return tileEntity != null && tileEntity.shouldRenderInPass(pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isGlobalRenderer(@Nonnull TileEntity te) {
        TileEntity tileEntity = this.getTileEntity(te.func_145831_w(), te.func_174877_v());
        if (tileEntity == null) {
            return false;
        }
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147546_a(tileEntity.getClass());
        if (tesr != null) {
            return tesr.func_188185_a(tileEntity);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTESR(@Nonnull TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntity tileEntity = this.getTileEntity(te.func_145831_w(), te.func_174877_v());
        if (tileEntity == null) {
            return;
        }
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147546_a(tileEntity.getClass());
        if (tesr != null) {
            tesr.func_192841_a(tileEntity, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    @Override
    public void onTextureSwitchEvent(TextureMap map) {
        this.itemModel = null;
    }

    @Override
    public TextureAtlasSprite getParticleTexture() {
        IBlockState state = this.getState();
        ItemStack renderItem = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_180651_a(state));
        return this.getItemModel(renderItem).func_177554_e();
    }

    @Override
    public String getType() {
        return "blockstate";
    }

    @Override
    public IRenderer fromJson(Gson gson, JsonObject jsonObject) {
        return new BlockStateRenderer((IBlockState)gson.fromJson(jsonObject.get("state"), IBlockState.class));
    }

    @Override
    public JsonObject toJson(Gson gson, JsonObject jsonObject) {
        jsonObject.add("state", gson.toJsonTree((Object)this.getState(), IBlockState.class));
        return jsonObject;
    }

    @Override
    public Supplier<IRenderer> createConfigurator(WidgetGroup parent, DraggableScrollableWidgetGroup group, IRenderer current) {
        BlockSelectorWidget blockSelectorWidget = new BlockSelectorWidget(0, 1, true);
        if (current instanceof BlockStateRenderer) {
            blockSelectorWidget.setBlock(((BlockStateRenderer)current).getState());
        }
        group.addWidget(blockSelectorWidget);
        return () -> {
            if (blockSelectorWidget.getBlock() == null) {
                return null;
            }
            return new BlockStateRenderer(blockSelectorWidget.getBlock());
        };
    }
}

