/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.renderer;

import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.block.ItemComponent;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.client.renderer.ICustomItemRenderer;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ComponentRenderer
implements ICustomItemRenderer {
    public static ComponentRenderer INSTANCE = new ComponentRenderer();
    public static final EnumBlockRenderType COMPONENT_RENDER_TYPE = (EnumBlockRenderType)EnumHelper.addEnum(EnumBlockRenderType.class, (String)"component_renderer", (Class[])new Class[0], (Object[])new Object[0]);

    @Override
    public void renderItem(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemComponent) {
            IRenderer renderer = ((ItemComponent)stack.func_77973_b()).getDefinition().getRenderer();
            if (renderer == null || renderer.isRaw()) {
                return;
            }
            renderer.renderItem(stack);
        }
    }

    public void renderBlockDamage(IBlockState state, BlockPos pos, TextureAtlasSprite texture, IBlockAccess blockAccess) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof ComponentTileEntity) {
            IRenderer renderer = ((ComponentTileEntity)tileEntity).getRenderer();
            if (renderer == null || renderer.isRaw()) {
                return;
            }
            renderer.renderBlockDamage(state, pos, texture, blockAccess);
        }
    }

    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder buffer) {
        TileEntity tileEntity = blockAccess.func_175625_s(pos);
        if (tileEntity instanceof ComponentTileEntity) {
            IRenderer renderer = ((ComponentTileEntity)tileEntity).getRenderer();
            if (renderer == null || renderer.isRaw()) {
                return false;
            }
            return renderer.renderBlock(state, pos, blockAccess, buffer);
        }
        if (state.func_177230_c() instanceof BlockComponent) {
            IRenderer renderer = ((BlockComponent)state.func_177230_c()).definition.getRenderer();
            if (renderer == null || renderer.isRaw()) {
                return false;
            }
            return renderer.renderBlock(state, pos, blockAccess, buffer);
        }
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }
}

