/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.particle;

import com.cleanroommc.multiblocked.client.particle.CommonParticle;
import com.cleanroommc.multiblocked.client.particle.IParticleHandler;
import com.cleanroommc.multiblocked.client.shader.Shaders;
import com.cleanroommc.multiblocked.client.shader.management.Shader;
import com.cleanroommc.multiblocked.client.shader.management.ShaderManager;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ShaderTextureParticle
extends CommonParticle {
    private static final Map<ResourceLocation, FBOShaderHandler> textureMap = new HashMap<ResourceLocation, FBOShaderHandler>();

    public ShaderTextureParticle(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
    }

    public static void clearShaders() {
        textureMap.values().forEach(handler -> handler.shader.deleteShader());
        textureMap.clear();
    }

    @Override
    public IParticleHandler getGLHandler() {
        return textureMap.computeIfAbsent(this.customTexture, shader -> new FBOShaderHandler(Shaders.load(Shader.ShaderType.FRAGMENT, this.customTexture)));
    }

    public static class FBOShaderHandler
    implements IParticleHandler {
        protected final Shader shader;
        public static final Framebuffer FBO = new Framebuffer(1024, 1024, false);
        private static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();

        public FBOShaderHandler(Shader shader) {
            this.shader = shader;
        }

        @Override
        public final void preDraw(BufferBuilder buffer) {
            if (this.shader != null) {
                int lastID = GL11.glGetInteger((int)36006);
                GL11.glGetInteger((int)2978, (IntBuffer)VIEWPORT_BUFFER);
                VIEWPORT_BUFFER.rewind();
                int x = VIEWPORT_BUFFER.get();
                int y = VIEWPORT_BUFFER.get();
                int width = VIEWPORT_BUFFER.get();
                int height = VIEWPORT_BUFFER.get();
                VIEWPORT_BUFFER.rewind();
                FBO.func_147614_f();
                ShaderManager.getInstance().renderFullImageInFramebuffer(FBO, this.shader, uniformCache -> {
                    Minecraft mc = Minecraft.func_71410_x();
                    float time = mc.field_71439_g != null ? ((float)mc.field_71439_g.field_70173_aa + mc.func_184121_ak()) / 20.0f : (float)System.currentTimeMillis() / 1000.0f;
                    uniformCache.glUniform1F("iTime", time);
                });
                GlStateManager.func_179083_b((int)x, (int)y, (int)width, (int)height);
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)lastID);
                GlStateManager.func_179144_i((int)FBOShaderHandler.FBO.field_147617_g);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        @Override
        public final void postDraw(BufferBuilder buffer) {
            Tessellator.func_178181_a().func_78381_a();
        }

        static {
            FBO.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }
}

