/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.particle;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.client.particle.IParticle;
import com.cleanroommc.multiblocked.client.particle.IParticleHandler;
import com.cleanroommc.multiblocked.client.util.EntityCamera;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleManager {
    public static final ParticleManager INSTANCE = new ParticleManager();
    private static World currentWorld = null;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Map<IParticleHandler, ArrayDeque<IParticle>> renderQueueBack = new HashMap<IParticleHandler, ArrayDeque<IParticle>>();
    private final Map<IParticleHandler, ArrayDeque<IParticle>> renderQueueFront = new HashMap<IParticleHandler, ArrayDeque<IParticle>>();
    private final Queue<Tuple<IParticleHandler, IParticle>> newParticleQueue = new ArrayDeque<Tuple<IParticleHandler, IParticle>>();
    public static double interPosX;
    public static double interPosY;
    public static double interPosZ;
    public static float rotationX;
    public static float rotationZ;
    public static float rotationYZ;
    public static float rotationXY;
    public static float rotationXZ;
    public static Vec3d cameraViewDir;
    public static Entity entity;

    public void addEffect(IParticle ... particles) {
        mc.func_152344_a(() -> {
            for (IParticle particle : particles) {
                if (particle.getGLHandler() == null) continue;
                this.newParticleQueue.add((Tuple<IParticleHandler, IParticle>)new Tuple((Object)particle.getGLHandler(), (Object)particle));
            }
        });
    }

    public void updateEffects() {
        this.updateEffectLayer();
        if (!this.newParticleQueue.isEmpty()) {
            Tuple<IParticleHandler, IParticle> handlerParticle = this.newParticleQueue.poll();
            while (handlerParticle != null) {
                IParticleHandler handler = (IParticleHandler)handlerParticle.func_76341_a();
                IParticle particle = (IParticle)handlerParticle.func_76340_b();
                Map<IParticleHandler, ArrayDeque<IParticle>> renderQueue = particle.isBackLayer() ? this.renderQueueBack : this.renderQueueFront;
                ArrayDeque arrayDeque = renderQueue.computeIfAbsent(handler, h -> new ArrayDeque());
                if (particle.isAddBlend()) {
                    if (arrayDeque.size() > 6000) {
                        ((IParticle)arrayDeque.removeFirst()).kill();
                    }
                    arrayDeque.add(particle);
                } else {
                    if (arrayDeque.size() > 6000) {
                        ((IParticle)arrayDeque.removeLast()).kill();
                    }
                    arrayDeque.addFirst(particle);
                }
                handlerParticle = this.newParticleQueue.poll();
            }
        }
    }

    private void updateEffectLayer() {
        if (!this.renderQueueBack.isEmpty()) {
            this.updateQueue(this.renderQueueBack);
        }
        if (!this.renderQueueFront.isEmpty()) {
            this.updateQueue(this.renderQueueFront);
        }
    }

    private void updateQueue(Map<IParticleHandler, ArrayDeque<IParticle>> renderQueue) {
        Iterator<Map.Entry<IParticleHandler, ArrayDeque<IParticle>>> entryIterator = renderQueue.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IParticleHandler, ArrayDeque<IParticle>> entry = entryIterator.next();
            Iterator<IParticle> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                IParticle particle = iterator.next();
                this.tickParticle(particle);
                if (particle.isAlive()) continue;
                iterator.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            entryIterator.remove();
        }
    }

    public void clearAllEffects(boolean cleanNewQueue) {
        if (cleanNewQueue) {
            for (Tuple tuple : this.newParticleQueue) {
                ((IParticle)tuple.func_76340_b()).kill();
            }
            this.newParticleQueue.clear();
        }
        for (ArrayDeque arrayDeque : this.renderQueueBack.values()) {
            arrayDeque.forEach(IParticle::kill);
        }
        for (ArrayDeque arrayDeque : this.renderQueueFront.values()) {
            arrayDeque.forEach(IParticle::kill);
        }
        this.renderQueueBack.clear();
        this.renderQueueFront.clear();
    }

    private void tickParticle(IParticle particle) {
        try {
            particle.onUpdate();
        }
        catch (Throwable throwable) {
            Multiblocked.LOGGER.error("particle update error: {}", (Object)particle.toString(), (Object)throwable);
            particle.kill();
        }
    }

    public void renderParticles(boolean back, Entity entityIn, float partialTicks) {
        if (back) {
            float radians = (float)Math.PI / 180;
            rotationX = MathHelper.func_76134_b((float)(entityIn.field_70177_z * radians));
            rotationZ = MathHelper.func_76126_a((float)(entityIn.field_70177_z * radians));
            rotationYZ = -rotationZ * MathHelper.func_76126_a((float)(entityIn.field_70125_A * radians));
            rotationXY = rotationX * MathHelper.func_76126_a((float)(entityIn.field_70125_A * radians));
            rotationXZ = MathHelper.func_76134_b((float)(entityIn.field_70125_A * radians));
            interPosX = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
            interPosY = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
            interPosZ = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
            cameraViewDir = entityIn.func_70676_i(partialTicks);
            entity = entityIn;
            if (entityIn instanceof EntityCamera) {
                interPosX *= 1.0E-5;
                interPosY *= 1.0E-5;
                interPosZ *= 1.0E-5;
            }
        }
        if (this.renderQueueBack.isEmpty() && back) {
            return;
        }
        if (this.renderQueueFront.isEmpty() && !back) {
            return;
        }
        GlStateManager.func_179147_l();
        ParticleManager.mc.field_71460_t.func_180436_i();
        RenderHelper.func_74518_a();
        Tessellator tessellator = Tessellator.func_178181_a();
        if (back) {
            this.renderGlParticlesInLayer(this.renderQueueBack, tessellator, entityIn, partialTicks);
        }
        if (!back) {
            this.renderGlParticlesInLayer(this.renderQueueFront, tessellator, entityIn, partialTicks);
        }
        ParticleManager.mc.field_71460_t.func_175072_h();
        RenderHelper.func_74519_b();
    }

    private void updateRenderInfo(Entity entityIn) {
    }

    private void renderGlParticlesInLayer(Map<IParticleHandler, ArrayDeque<IParticle>> renderQueue, Tessellator tessellator, Entity entityIn, float partialTicks) {
        for (IParticleHandler handler : renderQueue.keySet()) {
            ArrayDeque<IParticle> particles = renderQueue.get(handler);
            if (particles.isEmpty()) continue;
            BufferBuilder buffer = tessellator.func_178180_c();
            boolean addBlend = false;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            handler.preDraw(buffer);
            for (IParticle particle : particles) {
                if (!particle.shouldRendered(entityIn, partialTicks)) continue;
                try {
                    if (!addBlend && particle.isAddBlend()) {
                        addBlend = true;
                        handler.postDraw(buffer);
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                        handler.preDraw(buffer);
                    }
                    particle.renderParticle(buffer, partialTicks);
                }
                catch (Throwable throwable) {
                    Multiblocked.LOGGER.error("particle render error: {}", (Object)particle.toString(), (Object)throwable);
                    particle.kill();
                }
            }
            handler.postDraw(buffer);
            if (!addBlend) continue;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || mc.func_147113_T()) {
            return;
        }
        if (currentWorld != ParticleManager.mc.field_71441_e) {
            INSTANCE.clearAllEffects(currentWorld != null);
            currentWorld = ParticleManager.mc.field_71441_e;
        }
        if (currentWorld != null) {
            INSTANCE.updateEffects();
        }
    }

    public static void debugOverlay(RenderGameOverlayEvent.Text event) {
        if (event.getLeft().size() >= 5) {
            String particleTxt = (String)event.getLeft().get(4);
            particleTxt = particleTxt + "." + TextFormatting.GOLD + " PARTICLE-BACK: " + INSTANCE.getStatistics(ParticleManager.INSTANCE.renderQueueBack) + TextFormatting.RED + " PARTICLE-FRONt: " + INSTANCE.getStatistics(ParticleManager.INSTANCE.renderQueueFront);
            event.getLeft().set(4, particleTxt);
        }
    }

    public String getStatistics(Map<IParticleHandler, ArrayDeque<IParticle>> renderQueue) {
        int g = 0;
        for (ArrayDeque<IParticle> queue : renderQueue.values()) {
            g += queue.size();
        }
        return " GLFX: " + g;
    }
}

