/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.particle;

import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTLaserParticle;
import com.cleanroommc.multiblocked.client.particle.AbstractParticle;
import com.cleanroommc.multiblocked.client.particle.IParticleHandler;
import com.cleanroommc.multiblocked.client.particle.ParticleManager;
import com.cleanroommc.multiblocked.client.renderer.fx.LaserBeamRenderer;
import com.cleanroommc.multiblocked.util.ResourceUtils;
import com.cleanroommc.multiblocked.util.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTLaserParticle")
public class LaserBeamParticle
extends AbstractParticle
implements ICTLaserParticle {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private int body = -1;
    private int head = -1;
    private Vector3 direction;
    private float beamHeight = 0.075f;
    private float headWidth;
    private float alpha = 1.0f;
    private float emit;
    private boolean verticalMode;
    public static IParticleHandler HANDLER = new IParticleHandler(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        public void preDraw(BufferBuilder buffer) {
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179129_p();
        }

        @Override
        public void postDraw(BufferBuilder buffer) {
            GlStateManager.func_179089_o();
            GlStateManager.func_179101_C();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    };

    public LaserBeamParticle(World worldIn, Vector3 startPos, Vector3 endPos) {
        super(worldIn, startPos.x, startPos.y, startPos.z);
        this.direction = endPos.copy().subtract(startPos);
    }

    @Override
    public LaserBeamParticle getInner() {
        return this;
    }

    @Override
    public boolean shouldRendered(Entity entityIn, float partialTicks) {
        if (this.squareRenderRange < 0) {
            return true;
        }
        Vec3d eyePos = entityIn.func_174824_e(partialTicks);
        return eyePos.func_186679_c(this.posX, this.posY, this.posZ) <= (double)this.squareRenderRange || eyePos.func_186679_c(this.posX + this.direction.x, this.posY + this.direction.y, this.posZ + this.direction.z) <= (double)this.squareRenderRange;
    }

    public void setBody(ResourceLocation location) {
        ITextureObject texture = ResourceUtils.getTextureObject(location);
        this.body = texture == null ? -1 : texture.func_110552_b();
    }

    public void setHead(ResourceLocation location) {
        ITextureObject texture = ResourceUtils.getTextureObject(location);
        this.head = texture == null ? -1 : texture.func_110552_b();
    }

    public void setStartPos(Vector3 startPos) {
        this.direction.add(this.posX, this.posY, this.posZ).subtract(startPos);
    }

    public void setEndPos(Vector3 endPos) {
        this.direction = endPos.copy().subtract(this.posX, this.posY, this.posZ);
    }

    @Override
    public void setBeamHeight(float beamHeight) {
        this.beamHeight = beamHeight;
    }

    @Override
    public void setHeadWidth(float headWidth) {
        this.headWidth = headWidth;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public void setEmit(float emit) {
        this.emit = emit;
    }

    @Override
    public void setVerticalMode(boolean verticalMode) {
        this.verticalMode = verticalMode;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderParticle(BufferBuilder buffer, float partialTicks) {
        double tX = this.posX - ParticleManager.interPosX;
        double tY = this.posY - ParticleManager.interPosY;
        double tZ = this.posZ - ParticleManager.interPosZ;
        GlStateManager.func_179137_b((double)tX, (double)tY, (double)tZ);
        Vector3 cameraDirection = null;
        if (!this.verticalMode) {
            cameraDirection = new Vector3(this.posX, this.posY, this.posZ).subtract(new Vector3(ParticleManager.entity.func_174824_e(partialTicks)));
        }
        float offset = -this.emit * ((float)LaserBeamParticle.MINECRAFT.field_71439_g.field_70173_aa + partialTicks);
        LaserBeamRenderer.renderRawBeam(this.body, this.head, this.direction, cameraDirection, this.beamHeight, this.headWidth, this.alpha, offset);
        GlStateManager.func_179137_b((double)(-tX), (double)(-tY), (double)(-tZ));
    }

    @Override
    public IParticleHandler getGLHandler() {
        return HANDLER;
    }
}

