/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.particle;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTTextureParticle;
import com.cleanroommc.multiblocked.client.particle.AbstractParticle;
import com.cleanroommc.multiblocked.client.particle.IParticleHandler;
import com.cleanroommc.multiblocked.client.particle.ParticleManager;
import com.cleanroommc.multiblocked.util.ResourceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTTextureParticle")
public class CommonParticle
extends AbstractParticle
implements ICTTextureParticle {
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final Map<ResourceLocation, IParticleHandler> textureMap = new HashMap<ResourceLocation, IParticleHandler>();
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    private AxisAlignedBB boundingBox = EMPTY_AABB;
    public boolean onGround;
    public boolean canCollide;
    public float width = 0.6f;
    public float height = 1.8f;
    public int particleTextureIndexX;
    public int particleTextureIndexY;
    public float particleScale;
    public float particleGravity;
    public float particleRed;
    public float particleGreen;
    public float particleBlue;
    public float particleAlpha = 1.0f;
    public int texturesCount = 1;
    public int lightMap = -1;
    public boolean motionless = false;
    protected ResourceLocation customTexture;

    public CommonParticle(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.setSize(0.2f, 0.2f);
        this.setPosition(posXIn, posYIn, posZIn);
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleScale = (Multiblocked.RNG.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleLife = (int)(4.0f / (Multiblocked.RNG.nextFloat() * 0.9f + 0.1f));
        this.canCollide = true;
    }

    @Override
    public void setMotion(double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        this.motionX = xSpeedIn;
        this.motionY = ySpeedIn;
        this.motionZ = zSpeedIn;
    }

    @Override
    public CommonParticle getInner() {
        return this;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        super.setPosition(x, y, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
        float f = this.width / 2.0f;
        float f1 = this.height;
        this.setBoundingBox(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    @Override
    public void setSize(float particleWidth, float particleHeight) {
        if (particleWidth != this.width || particleHeight != this.height) {
            this.width = particleWidth;
            this.height = particleHeight;
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    @Override
    public void setMotionless(boolean motionless) {
        this.motionless = motionless;
    }

    @Override
    public void setColor(int color) {
        this.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
        this.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        this.particleBlue = (float)(color & 0xFF) / 255.0f;
        this.particleAlpha = (float)(color >> 24 & 0xFF) / 255.0f;
    }

    @Override
    public void setScale(float scale) {
        this.particleScale = scale;
    }

    @Override
    public void setGravity(float gravity) {
        this.particleGravity = gravity;
    }

    @Override
    public void setTexturesIndex(int particleTextureIndexX, int particleTextureIndexY) {
        this.particleTextureIndexX = particleTextureIndexX;
        this.particleTextureIndexY = particleTextureIndexY;
    }

    @Override
    public void setTexturesCount(int texturesCount) {
        this.texturesCount = texturesCount;
    }

    public void setParticleTextureIndex(int particleTextureIndex) {
        this.particleTextureIndexX = particleTextureIndex % this.texturesCount;
        this.particleTextureIndexY = particleTextureIndex / this.texturesCount;
    }

    public float getTexturesCount() {
        return this.texturesCount;
    }

    public boolean isMotionless() {
        return this.motionless;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.move(this.motionX, this.motionY, this.motionZ);
        if (!this.motionless) {
            this.motionY -= 0.04 * (double)this.particleGravity;
            this.motionX *= (double)0.98f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.98f;
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
            }
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(AxisAlignedBB bb) {
        this.boundingBox = bb;
    }

    public void move(double x, double y, double z) {
        double d0 = y;
        double origX = x;
        double origZ = z;
        if (this.canCollide) {
            List list = this.world.func_184144_a(null, this.getBoundingBox().func_72321_a(x, y, z));
            for (AxisAlignedBB axisalignedbb : list) {
                y = axisalignedbb.func_72323_b(this.getBoundingBox(), y);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(0.0, y, 0.0));
            for (AxisAlignedBB axisalignedbb1 : list) {
                x = axisalignedbb1.func_72316_a(this.getBoundingBox(), x);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(x, 0.0, 0.0));
            for (AxisAlignedBB axisalignedbb2 : list) {
                z = axisalignedbb2.func_72322_c(this.getBoundingBox(), z);
            }
            this.setBoundingBox(this.getBoundingBox().func_72317_d(0.0, 0.0, z));
        } else {
            this.setBoundingBox(this.getBoundingBox().func_72317_d(x, y, z));
        }
        AxisAlignedBB axisalignedbb = this.getBoundingBox();
        this.posX = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.posY = axisalignedbb.field_72338_b;
        this.posZ = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        boolean bl = this.onGround = d0 != y && d0 < 0.0;
        if (origX != x) {
            this.motionX = 0.0;
        }
        if (origZ != z) {
            this.motionZ = 0.0;
        }
    }

    @Override
    public void renderParticle(BufferBuilder buffer, float partialTicks) {
        float rotationX = ParticleManager.rotationX;
        float rotationZ = ParticleManager.rotationXZ;
        float rotationYZ = ParticleManager.rotationZ;
        float rotationXY = ParticleManager.rotationYZ;
        float rotationXZ = ParticleManager.rotationXY;
        float minU = (float)this.particleTextureIndexX * 1.0f / (float)this.texturesCount;
        float maxU = minU + 1.0f / (float)this.texturesCount;
        float minV = (float)this.particleTextureIndexY * 1.0f / (float)this.texturesCount;
        float maxV = minV + 1.0f / (float)this.texturesCount;
        float scale = 0.1f * this.particleScale;
        float renderX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks - ParticleManager.interPosX);
        float renderY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks - ParticleManager.interPosY);
        float renderZ = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks - ParticleManager.interPosZ);
        int brightnessForRender = this.getBrightnessForRender();
        int j = brightnessForRender >> 16 & 0xFFFF;
        int k = brightnessForRender & 0xFFFF;
        buffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_187314_a(j, k).func_181675_d();
    }

    public int getBrightnessForRender() {
        if (this.lightMap >= 0) {
            return this.lightMap;
        }
        BlockPos blockpos = new BlockPos(this.posX, this.posY, this.posZ);
        return this.world.func_175667_e(blockpos) ? this.world.func_175626_b(blockpos, 0) : 0;
    }

    public void setTexture(ResourceLocation texture) {
        this.customTexture = texture;
    }

    @Override
    public void setLightingMap(int block, int sky) {
        this.lightMap = (block * 16 & 0xFFFF) << 16 | sky * 16 & 0xFFFF;
    }

    @Override
    public IParticleHandler getGLHandler() {
        return textureMap.computeIfAbsent(this.customTexture, TexturedParticleHandler::new);
    }

    private static class TexturedParticleHandler
    implements IParticleHandler {
        private final ResourceLocation texture;

        public TexturedParticleHandler(ResourceLocation texture) {
            this.texture = texture;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void preDraw(BufferBuilder buffer) {
            ResourceUtils.bindTexture(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void postDraw(BufferBuilder buffer) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }
}

