/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.particle;

import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTParticle;
import com.cleanroommc.multiblocked.client.particle.IParticle;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTParticle")
public abstract class AbstractParticle
implements IParticle,
ICTParticle {
    public World world;
    public double posX;
    public double posY;
    public double posZ;
    public boolean isBackLayer;
    public boolean isAddBlend;
    public int particleLife;
    public int squareRenderRange;
    public Consumer<AbstractParticle> onUpdate;

    public AbstractParticle(World world, double posX, double posY, double posZ) {
        this.world = world;
        this.squareRenderRange = -1;
        this.setPosition(posX, posY, posZ);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public double getX() {
        return this.posX;
    }

    @Override
    public double getY() {
        return this.posY;
    }

    @Override
    public double getZ() {
        return this.posZ;
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void setLife(int life) {
        if (this.squareRenderRange == -1 && life > 500) {
            this.setRenderRange(64);
        }
        this.particleLife = life;
    }

    @Override
    public int getLife() {
        return this.particleLife;
    }

    @Override
    public void setAddBlend(boolean addBlend) {
        this.isAddBlend = addBlend;
    }

    @Override
    public AbstractParticle getInner() {
        return this;
    }

    @Override
    public boolean isBackLayer() {
        return this.isBackLayer;
    }

    @Override
    public boolean isAddBlend() {
        return this.isAddBlend;
    }

    @Override
    public void setBackLayer(boolean isBackLayer) {
        this.isBackLayer = isBackLayer;
    }

    @Override
    public void kill() {
        this.particleLife = 0;
    }

    @Override
    public boolean isAlive() {
        return this.particleLife != 0;
    }

    @Override
    public void onUpdate() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this);
        }
        if (this.particleLife > 0) {
            --this.particleLife;
        }
    }

    @Override
    public boolean shouldRendered(Entity entityIn, float partialTicks) {
        if (this.squareRenderRange < 0) {
            return true;
        }
        return entityIn.func_174824_e(partialTicks).func_186679_c(this.posX, this.posY, this.posZ) <= (double)this.squareRenderRange;
    }

    @Override
    public void setRenderRange(int renderRange) {
        this.squareRenderRange = renderRange * renderRange;
    }

    @Override
    public int getRenderRange() {
        return this.squareRenderRange >= 0 ? -1 : (int)Math.sqrt(this.squareRenderRange);
    }

    @Override
    public void setImmortal() {
        if (this.squareRenderRange == -1) {
            this.setRenderRange(64);
        }
        this.particleLife = -1;
    }

    public void setOnUpdate(Consumer<AbstractParticle> onUpdate) {
        this.onUpdate = onUpdate;
    }
}

