/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.model.custommodel;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MetadataSectionEmissive
implements IMetadataSection {
    public static final String SECTION_NAME = "multiblocked";
    private static final Map<ResourceLocation, MetadataSectionEmissive> METADATA_CACHE = new HashMap<ResourceLocation, MetadataSectionEmissive>();
    public final boolean emissive;
    private final BlockRenderLayer layer;

    public MetadataSectionEmissive() {
        this.emissive = false;
        this.layer = null;
    }

    public MetadataSectionEmissive(boolean emissive, BlockRenderLayer layer) {
        this.emissive = emissive;
        this.layer = layer;
    }

    @Nullable
    public static MetadataSectionEmissive getMetadata(ResourceLocation res) {
        MetadataSectionEmissive ret;
        if (METADATA_CACHE.containsKey(res)) {
            return METADATA_CACHE.get(res);
        }
        try (IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(res);){
            ret = (MetadataSectionEmissive)resource.func_110526_a(SECTION_NAME);
        }
        catch (Exception e) {
            ret = null;
        }
        METADATA_CACHE.put(res, ret);
        return ret;
    }

    public static boolean isEmissive(TextureAtlasSprite sprite) {
        MetadataSectionEmissive ret = MetadataSectionEmissive.getMetadata(MetadataSectionEmissive.spriteToAbsolute(new ResourceLocation(sprite.func_94215_i())));
        return ret != null && ret.emissive;
    }

    public static BlockRenderLayer getLayer(TextureAtlasSprite sprite) {
        MetadataSectionEmissive ret = MetadataSectionEmissive.getMetadata(MetadataSectionEmissive.spriteToAbsolute(new ResourceLocation(sprite.func_94215_i())));
        return ret == null ? null : ret.layer;
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.func_110623_a().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), "textures/" + sprite.func_110623_a());
        }
        if (!sprite.func_110623_a().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), sprite.func_110623_a() + ".png");
        }
        return sprite;
    }

    public static class Serializer
    implements IMetadataSectionSerializer<MetadataSectionEmissive> {
        @Nullable
        public MetadataSectionEmissive deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) throws JsonParseException {
            boolean emissive = false;
            BlockRenderLayer layer = null;
            if (json != null && json.isJsonObject()) {
                JsonElement element;
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("emissive") && (element = obj.get("emissive")).isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                    emissive = element.getAsBoolean();
                }
                if (obj.has("layer") && (element = obj.get("emissive")).isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    layer = BlockRenderLayer.valueOf((String)element.getAsString());
                }
            }
            return new MetadataSectionEmissive(emissive, layer);
        }

        @Nonnull
        public String func_110483_a() {
            return MetadataSectionEmissive.SECTION_NAME;
        }
    }
}

