/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.model.custommodel;

import com.cleanroommc.multiblocked.client.model.bakedpipeline.VertexBuilder;
import com.cleanroommc.multiblocked.client.model.custommodel.MetadataSectionEmissive;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector2f;

@SideOnly(value=Side.CLIENT)
public class CustomBakedModel
implements IBakedModel {
    private final IBakedModel parent;
    private final Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> sideCache;
    private final EnumMap<BlockRenderLayer, List<BakedQuad>> noSideCache;

    public CustomBakedModel(IBakedModel parent) {
        this.parent = parent;
        this.noSideCache = new EnumMap(BlockRenderLayer.class);
        this.sideCache = Tables.newCustomTable(new EnumMap(BlockRenderLayer.class), () -> new EnumMap(EnumFacing.class));
    }

    public boolean shouldRenderInLayer(@Nullable IBlockState state, long rand) {
        if (!this.func_188616_a(state, null, rand).isEmpty()) {
            return true;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.func_188616_a(state, side, rand).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer currentLayer = MinecraftForgeClient.getRenderLayer();
        BlockRenderLayer blockRenderLayer = currentLayer = currentLayer == null ? BlockRenderLayer.CUTOUT : currentLayer;
        if (side == null) {
            if (!this.noSideCache.containsKey(currentLayer)) {
                this.reBake(currentLayer, state, null, rand);
            }
            return this.noSideCache.get(currentLayer);
        }
        if (!this.sideCache.contains((Object)currentLayer, (Object)side)) {
            this.reBake(currentLayer, state, side, rand);
        }
        return (List)this.sideCache.get((Object)currentLayer, (Object)side);
    }

    public void reBake(BlockRenderLayer currentLayer, @Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        List parentQuads = this.parent.func_188616_a(state, side, rand);
        LinkedList<BakedQuad> resultQuads = new LinkedList<BakedQuad>();
        for (BakedQuad quad : parentQuads) {
            TextureAtlasSprite sprite = quad.func_187508_a();
            boolean isEmissive = MetadataSectionEmissive.isEmissive(sprite);
            BlockRenderLayer layer = MetadataSectionEmissive.getLayer(sprite);
            layer = layer == null ? BlockRenderLayer.CUTOUT : layer;
            if (currentLayer != layer) continue;
            if (isEmissive) {
                quad = CustomBakedModel.reBakeEmissive(quad);
            }
            resultQuads.add(quad);
        }
        if (side == null) {
            this.noSideCache.put(currentLayer, resultQuads);
        } else {
            this.sideCache.put((Object)currentLayer, (Object)side, resultQuads);
        }
    }

    public static BakedQuad reBakeEmissive(BakedQuad quad) {
        VertexBuilder builder = new VertexBuilder(quad.getFormat(), quad.func_187508_a());
        quad.pipe((IVertexConsumer)builder);
        VertexFormat format = builder.vertexFormat;
        if (format == DefaultVertexFormats.field_176599_b) {
            format = DefaultVertexFormats.field_176600_a;
        } else if (!format.func_177343_g().contains(DefaultVertexFormats.field_181716_p)) {
            format = new VertexFormat(format).func_181721_a(DefaultVertexFormats.field_181716_p);
        }
        UnpackedBakedQuad.Builder unpackedBuilder = new UnpackedBakedQuad.Builder(format);
        unpackedBuilder.setQuadOrientation(builder.quadOrientation);
        unpackedBuilder.setQuadTint(builder.quadTint);
        unpackedBuilder.setApplyDiffuseLighting(builder.applyDiffuseLighting);
        unpackedBuilder.setTexture(builder.sprite);
        Vector2f[] uvs = builder.uvs();
        for (int v = 0; v < 4; ++v) {
            for (int i = 0; i < format.func_177345_h(); ++i) {
                VertexFormatElement ele = format.func_177348_c(i);
                if (ele.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                    unpackedBuilder.put(i, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue;
                }
                if (ele.func_177375_c() == VertexFormatElement.EnumUsage.UV) {
                    if (ele.func_177369_e() == 1) {
                        unpackedBuilder.put(i, new float[]{0.0073243305f, 0.0073243305f});
                        continue;
                    }
                    if (ele.func_177369_e() != 0) continue;
                    Vector2f uv = uvs[v];
                    unpackedBuilder.put(i, new float[]{uv.x, uv.y, 0.0f, 1.0f});
                    continue;
                }
                unpackedBuilder.put(i, (float[])builder.data.get((Object)ele.func_177375_c()).get(v));
            }
        }
        return unpackedBuilder.build();
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }

    public boolean isAmbientOcclusion(@Nonnull IBlockState state) {
        return this.parent.func_177555_b();
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        return this.parent.handlePerspective(cameraTransformType);
    }
}

