/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.client.model;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelFactory {
    private static final Map<ItemCameraTransforms.TransformType, TRSRTransformation> blockTransformationMap = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
    private static final Map<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransformationMap = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
    private static FaceBakery INSTANCE;
    private final ModelTemplate template;
    private final Map<String, String> sprites;
    private final IModelState state;
    private VertexFormat format;
    private UnaryOperator<IModel> mutation;

    public static FaceBakery getBakery() {
        if (INSTANCE == null) {
            INSTANCE = new FaceBakery();
        }
        return INSTANCE;
    }

    public static TRSRTransformation getBlockTransform(ItemCameraTransforms.TransformType transformType) {
        return blockTransformationMap.get(transformType);
    }

    public static TRSRTransformation getItemTransform(ItemCameraTransforms.TransformType transformType) {
        return itemTransformationMap.get(transformType);
    }

    private static TRSRTransformation getTransform(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public ModelFactory(ModelTemplate template) {
        this.template = template;
        this.sprites = new Object2ObjectOpenHashMap();
        this.state = template.model.getDefaultState();
        this.format = DefaultVertexFormats.field_176600_a;
    }

    public ModelFactory addSpriteToLayer(int layer, ResourceLocation textureLocation) {
        return this.addSpriteToLayer(layer, textureLocation.toString());
    }

    public ModelFactory addSpriteToLayer(int layer, String textureLocation) {
        this.sprites.put("layer" + layer, textureLocation);
        return this;
    }

    public ModelFactory addSprite(String element, ResourceLocation textureLocation) {
        return this.addSprite(element, textureLocation.toString());
    }

    public ModelFactory addSprite(String element, String textureLocation) {
        this.sprites.put(element, textureLocation);
        return this;
    }

    public ModelFactory addParticleSprite(ResourceLocation textureLocation) {
        return this.addParticleSprite(textureLocation.toString());
    }

    public ModelFactory addParticleSprite(String textureLocation) {
        this.sprites.put("particle", textureLocation);
        return this;
    }

    public ModelFactory changeFormat(VertexFormat format) {
        this.format = format;
        return this;
    }

    public ModelFactory mutateModel(UnaryOperator<IModel> mutate) {
        this.mutation = mutate;
        return this;
    }

    public IModel getMappedModel() {
        return this.template.model.retexture(ImmutableMap.copyOf(this.sprites));
    }

    public IBakedModel bake() {
        IModel mapped = this.getMappedModel();
        if (this.mutation != null) {
            this.mutation.apply(mapped);
        }
        return mapped.bake(mapped.getDefaultState(), this.format, ModelLoader.defaultTextureGetter());
    }

    public static IModel getModel(ResourceLocation resourceLocation) {
        return ModelLoaderRegistry.getModelOrMissing((ResourceLocation)resourceLocation);
    }

    static {
        blockTransformationMap.put(ItemCameraTransforms.TransformType.GUI, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        blockTransformationMap.put(ItemCameraTransforms.TransformType.GROUND, ModelFactory.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        blockTransformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        blockTransformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f));
        blockTransformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.0f, 0.4f));
        blockTransformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.0f, 0.4f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.GUI, ModelFactory.getTransform(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.GROUND, ModelFactory.getTransform(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, ModelFactory.getTransform(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, ModelFactory.getTransform(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, ModelFactory.getTransform(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        itemTransformationMap.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, ModelFactory.getTransform(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
    }

    public static class ModelTemplate {
        public static final ModelTemplate CUBE_2_LAYER = new ModelTemplate("multiblocked", "block/cube_2_layer");
        public static final ModelTemplate BLOCK = new ModelTemplate("minecraft", "block/block");
        public static final ModelTemplate NORMAL_ITEM = new ModelTemplate("minecraft", "item/generated");
        public static final ModelTemplate HANDHELD_ITEM = new ModelTemplate("minecraft", "item/handheld");
        private final IModel model;

        public ModelTemplate(String locationDomain, String locationPath) {
            this.model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation(locationDomain, locationPath));
        }

        public IModel getModel() {
            return this.model;
        }
    }
}

