/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.tile.part;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTPart;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTPart")
public abstract class PartTileEntity<T extends PartDefinition>
extends ComponentTileEntity<T>
implements ICTPart {
    public Set<BlockPos> controllerPos = new HashSet<BlockPos>();

    @Override
    public PartTileEntity<?> getInner() {
        return this;
    }

    @Override
    public boolean isFormed() {
        for (BlockPos blockPos : this.controllerPos) {
            TileEntity controller = this.field_145850_b.func_175625_s(blockPos);
            if (!(controller instanceof ControllerTileEntity) || !((ControllerTileEntity)controller).isFormed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStatus() {
        boolean isIdle = false;
        for (ControllerTileEntity controller : this.getControllers()) {
            if (controller.getStatus().equals("idle")) {
                isIdle = true;
            }
            if (!controller.getStatus().equals("working")) continue;
            return "working";
        }
        return isIdle ? "idle" : "unformed";
    }

    public boolean canShared() {
        return ((PartDefinition)this.definition).canShared;
    }

    public List<ControllerTileEntity> getControllers() {
        ArrayList<ControllerTileEntity> result = new ArrayList<ControllerTileEntity>();
        for (BlockPos blockPos : this.controllerPos) {
            TileEntity controller = this.field_145850_b.func_175625_s(blockPos);
            if (!(controller instanceof ControllerTileEntity) || !((ControllerTileEntity)controller).isFormed()) continue;
            result.add((ControllerTileEntity)controller);
        }
        return result;
    }

    public void addedToController(@Nonnull ControllerTileEntity controller) {
        if (this.controllerPos.add(controller.func_174877_v())) {
            this.writeCustomData(-1, this::writeControllersToBuffer);
            if (((PartDefinition)this.definition).partAddedToMulti != null) {
                try {
                    ((PartDefinition)this.definition).partAddedToMulti.apply(this, controller);
                }
                catch (Exception exception) {
                    ((PartDefinition)this.definition).partAddedToMulti = null;
                    Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((PartDefinition)this.definition).location, (Object)"partAddedToMulti", (Object)exception);
                }
            }
            this.setStatus("idle");
        }
    }

    public void removedFromController(@Nonnull ControllerTileEntity controller) {
        if (this.controllerPos.remove(controller.func_174877_v())) {
            this.writeCustomData(-1, this::writeControllersToBuffer);
            if (((PartDefinition)this.definition).partRemovedFromMulti != null) {
                try {
                    ((PartDefinition)this.definition).partRemovedFromMulti.apply(this, controller);
                }
                catch (Exception exception) {
                    ((PartDefinition)this.definition).partRemovedFromMulti = null;
                    Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((PartDefinition)this.definition).location, (Object)"partRemovedFromMulti", (Object)exception);
                }
            }
            if (this.getControllers().isEmpty()) {
                this.setStatus("unformed");
            }
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeControllersToBuffer(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readControllersFromBuffer(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == -1) {
            this.readControllersFromBuffer(buf);
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (MultiblockState state : MultiblockWorldSavedData.getOrCreate(this.field_145850_b).getControllerInChunk(new ChunkPos(this.field_174879_c))) {
            if (!state.isPosInCache(this.field_174879_c)) continue;
            this.controllerPos.add(state.controllerPos);
        }
    }

    private void writeControllersToBuffer(PacketBuffer buffer) {
        buffer.func_150787_b(this.controllerPos.size());
        for (BlockPos pos : this.controllerPos) {
            buffer.func_179255_a(pos);
        }
    }

    private void readControllersFromBuffer(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        this.controllerPos.clear();
        for (int i = size; i > 0; --i) {
            this.controllerPos.add(buffer.func_179259_c());
        }
    }

    public static class PartSimpleTileEntity
    extends PartTileEntity<PartDefinition> {
    }
}

