/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.tile;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.ModularUIBuilder;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.IOPageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.RecipePage;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.structure.StructurePageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tester.ControllerScriptWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tester.ZSScriptWidget;
import com.cleanroommc.multiblocked.api.pattern.FactoryBlockPattern;
import com.cleanroommc.multiblocked.api.pattern.Predicates;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.client.renderer.impl.IModelRenderer;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ControllerTileTesterEntity
extends ControllerTileEntity {
    public static final ControllerDefinition DEFAULT_DEFINITION = new ControllerDefinition(new ResourceLocation("multiblocked:controller_tester"), (Class<? extends ControllerTileEntity>)ControllerTileTesterEntity.class);

    @Override
    public void setDefinition(ComponentDefinition definition) {
        MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(this.field_145850_b);
        this.state = null;
        if (this.field_174879_c != null && mwsd.mapping.containsKey(this.field_174879_c)) {
            mwsd.removeMapping(mwsd.mapping.get(this.field_174879_c));
        }
        if (definition == null) {
            definition = DEFAULT_DEFINITION;
        } else if (definition != DEFAULT_DEFINITION && this.field_145850_b != null) {
            if (this.isRemote()) {
                this.scheduleChunkForRenderUpdate();
            } else {
                this.notifyBlockUpdate();
                super.setDefinition(definition);
                if (this.needAlwaysUpdate()) {
                    MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addLoading(this);
                }
                return;
            }
        }
        super.setDefinition(definition);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.recipeLogic = new RecipeLogic(this);
    }

    @Override
    public ModularUI createUI(EntityPlayer entityPlayer) {
        if (Multiblocked.isClient() && Multiblocked.isSinglePlayer()) {
            TabContainer tabContainer = new TabContainer(0, 0, 200, 232);
            new ControllerScriptWidget(this, tabContainer);
            if (Loader.isModLoaded((String)"crafttweaker")) {
                new ZSScriptWidget(tabContainer);
            }
            if (this.getDefinition() != DEFAULT_DEFINITION) {
                if (!this.traits.isEmpty()) {
                    this.initTraitUI(tabContainer, entityPlayer);
                }
                if (this.isFormed()) {
                    new RecipePage(this, tabContainer);
                    new IOPageWidget(this, tabContainer);
                } else {
                    new StructurePageWidget((ControllerDefinition)this.definition, tabContainer);
                }
            }
            return new ModularUIBuilder(IGuiTexture.EMPTY, 196, 256).widget(tabContainer).build(this, entityPlayer);
        }
        return null;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        compound.func_74778_a("loc", ControllerTileTesterEntity.DEFAULT_DEFINITION.location.toString());
        super.func_145839_a(compound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74778_a("loc", ControllerTileTesterEntity.DEFAULT_DEFINITION.location.toString());
        return compound;
    }

    public static void registerTestController() {
        DEFAULT_DEFINITION.getBaseStatus().setRenderer(new IModelRenderer(new ResourceLocation("multiblocked", "block/controller_tester")));
        ControllerTileTesterEntity.DEFAULT_DEFINITION.properties.isOpaque = false;
        DEFAULT_DEFINITION.setBasePattern(FactoryBlockPattern.start().aisle("@").where('@', Predicates.component(DEFAULT_DEFINITION)).build());
        MbdComponents.registerComponent(DEFAULT_DEFINITION);
    }
}

