/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.tile;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.ICapabilityProxyHolder;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTController;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.gui.factory.TileEntityUIFactory;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.util.ModularUIBuilder;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.IOPageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.RecipePage;
import com.cleanroommc.multiblocked.api.gui.widget.imp.controller.structure.StructurePageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.pattern.BlockPattern;
import com.cleanroommc.multiblocked.api.pattern.MultiblockState;
import com.cleanroommc.multiblocked.api.pattern.error.PatternStringError;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import com.cleanroommc.multiblocked.api.tile.part.PartTileEntity;
import com.cleanroommc.multiblocked.client.renderer.MultiblockPreviewRenderer;
import com.cleanroommc.multiblocked.persistence.IAsyncThreadUpdate;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import crafttweaker.api.minecraft.CraftTweakerMC;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTController")
public class ControllerTileEntity
extends ComponentTileEntity<ControllerDefinition>
implements ICapabilityProxyHolder,
ICTController,
IAsyncThreadUpdate {
    public MultiblockState state;
    public boolean asyncRecipeSearching = true;
    protected Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> capabilities;
    private Map<Long, Map<MultiblockCapability<?>, Tuple<IO, EnumFacing>>> settings;
    protected LongOpenHashSet parts;
    protected RecipeLogic recipeLogic;
    protected AxisAlignedBB renderBox;
    protected IBlockState oldState;
    protected NBTTagCompound oldNbt;

    public BlockPattern getPattern() {
        if (((ControllerDefinition)this.definition).dynamicPattern != null) {
            try {
                return ((ControllerDefinition)this.definition).dynamicPattern.apply(this);
            }
            catch (Exception exception) {
                ((ControllerDefinition)this.definition).dynamicPattern = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ControllerDefinition)this.definition).location, (Object)"dynamicPattern", (Object)exception);
            }
        }
        return ((ControllerDefinition)this.definition).getBasePattern();
    }

    @Override
    public ControllerTileEntity getInner() {
        return this;
    }

    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    public boolean checkPattern() {
        if (this.state == null) {
            return false;
        }
        return this.getPattern().checkPatternAt(this.state, false);
    }

    @Override
    public boolean shouldCheckPattern() {
        if (((ControllerDefinition)this.definition).shouldCheckPattern == null) {
            return true;
        }
        return ((ControllerDefinition)this.definition).shouldCheckPattern.apply(this);
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing.func_176740_k() != EnumFacing.Axis.Y;
    }

    @Override
    public boolean isFormed() {
        return this.state != null && this.state.isFormed();
    }

    @Override
    public void update() {
        super.update();
        if (this.isFormed()) {
            this.updateFormed();
        }
    }

    public void updateFormed() {
        if (this.recipeLogic != null) {
            this.recipeLogic.update();
        }
        if (((ControllerDefinition)this.definition).updateFormed != null) {
            try {
                ((ControllerDefinition)this.definition).updateFormed.apply(this);
            }
            catch (Exception exception) {
                ((ControllerDefinition)this.definition).updateFormed = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ControllerDefinition)this.definition).location, (Object)"updateFormed", (Object)exception);
            }
        }
    }

    @Override
    public Table<IO, MultiblockCapability<?>, Long2ObjectOpenHashMap<CapabilityProxy<?>>> getCapabilities() {
        return this.capabilities;
    }

    public void onStructureFormed() {
        TileEntity tileEntity;
        if (this.recipeLogic == null) {
            this.recipeLogic = new RecipeLogic(this);
        }
        if (this.status.equals("unformed")) {
            this.setStatus("idle");
        }
        Map capabilityMap = (Map)this.state.getMatchContext().get("capabilities");
        Map slotsMap = (Map)this.state.getMatchContext().get("slots");
        if (capabilityMap != null) {
            this.capabilities = Tables.newCustomTable(new EnumMap(IO.class), Object2ObjectOpenHashMap::new);
            for (Map.Entry entry : capabilityMap.entrySet()) {
                tileEntity = this.field_145850_b.func_175625_s(BlockPos.func_177969_a((long)((Long)entry.getKey())));
                if (tileEntity == null) continue;
                if (this.settings != null) {
                    Map<MultiblockCapability<?>, Tuple<IO, EnumFacing>> caps = this.settings.get(entry.getKey());
                    if (caps == null) continue;
                    for (Map.Entry<MultiblockCapability<?>, Tuple<IO, EnumFacing>> ioEntry : caps.entrySet()) {
                        MultiblockCapability<?> capability = ioEntry.getKey();
                        Tuple<IO, EnumFacing> tuple = ioEntry.getValue();
                        if (tuple == null || capability == null) continue;
                        IO io2 = (IO)((Object)tuple.func_76341_a());
                        EnumFacing facing = (EnumFacing)tuple.func_76340_b();
                        if (!capability.isBlockHasCapability(io2, tileEntity)) continue;
                        if (!this.capabilities.contains((Object)io2, capability)) {
                            this.capabilities.put((Object)io2, capability, (Object)new Long2ObjectOpenHashMap());
                        }
                        CapabilityProxy<?> proxy = capability.createProxy(io2, tileEntity, facing, slotsMap);
                        ((Long2ObjectOpenHashMap)this.capabilities.get((Object)io2, capability)).put(((Long)entry.getKey()).longValue(), proxy);
                    }
                    continue;
                }
                ((EnumMap)entry.getValue()).forEach((io, set) -> {
                    for (MultiblockCapability capability : set) {
                        if (!capability.isBlockHasCapability((IO)((Object)io), tileEntity)) continue;
                        if (!this.capabilities.contains((Object)io, (Object)capability)) {
                            this.capabilities.put((Object)io, (Object)capability, (Object)new Long2ObjectOpenHashMap());
                        }
                        CapabilityProxy proxy = capability.createProxy((IO)((Object)io), tileEntity, EnumFacing.UP, slotsMap);
                        ((Long2ObjectOpenHashMap)this.capabilities.get((Object)io, (Object)capability)).put(((Long)entry.getKey()).longValue(), proxy);
                    }
                });
            }
        }
        this.settings = null;
        this.parts = (LongOpenHashSet)this.state.getMatchContext().get("parts");
        if (this.parts != null) {
            for (Long pos : this.parts) {
                tileEntity = this.field_145850_b.func_175625_s(BlockPos.func_177969_a((long)pos));
                if (!(tileEntity instanceof PartTileEntity)) continue;
                ((PartTileEntity)tileEntity).addedToController(this);
            }
        }
        this.writeCustomData(-1, this::writeState);
        if (((ControllerDefinition)this.definition).structureFormed != null) {
            try {
                ((ControllerDefinition)this.definition).structureFormed.apply(this);
            }
            catch (Exception exception) {
                ((ControllerDefinition)this.definition).structureFormed = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ControllerDefinition)this.definition).location, (Object)"structureFormed", (Object)exception);
            }
        }
    }

    public void onStructureInvalid() {
        this.recipeLogic = null;
        this.setStatus("unformed");
        if (this.parts != null) {
            for (Long pos : this.parts) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(BlockPos.func_177969_a((long)pos));
                if (!(tileEntity instanceof PartTileEntity)) continue;
                ((PartTileEntity)tileEntity).removedFromController(this);
            }
            this.parts = null;
        }
        this.capabilities = null;
        this.writeCustomData(-1, this::writeState);
        if (((ControllerDefinition)this.definition).structureInvalid != null) {
            try {
                ((ControllerDefinition)this.definition).structureInvalid.apply(this);
            }
            catch (Exception exception) {
                ((ControllerDefinition)this.definition).structureInvalid = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ControllerDefinition)this.definition).location, (Object)"structureInvalid", (Object)exception);
            }
        }
    }

    public boolean hasOldBlock() {
        return ((ControllerDefinition)this.getDefinition()).noNeedController && this.oldState != null && this.field_145850_b != null;
    }

    public void resetOldBlock(World world, BlockPos pos) {
        TileEntity blockEntity;
        world.func_175656_a(pos, this.oldState);
        if (this.oldNbt != null && (blockEntity = TileEntity.func_190200_a((World)world, (NBTTagCompound)this.oldNbt)) != null) {
            this.field_145850_b.func_175690_a(pos, blockEntity);
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == -1) {
            this.readState(buf);
            this.scheduleChunkForRenderUpdate();
        } else {
            super.receiveCustomData(dataId, buf);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeState(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readState(buf);
        this.scheduleChunkForRenderUpdate();
    }

    protected void writeState(PacketBuffer buffer) {
        buffer.writeBoolean(this.isFormed());
        if (this.isFormed()) {
            LongSet disabled = (LongSet)this.state.getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
            buffer.func_150787_b(disabled.size());
            LongIterator longIterator = disabled.iterator();
            while (longIterator.hasNext()) {
                long blockPos = (Long)longIterator.next();
                buffer.writeLong(blockPos);
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            for (BlockPos pos : this.state.getCache()) {
                minX = Math.min(minX, pos.func_177958_n());
                minY = Math.min(minY, pos.func_177956_o());
                minZ = Math.min(minZ, pos.func_177952_p());
                maxX = Math.max(maxX, pos.func_177958_n());
                maxY = Math.max(maxY, pos.func_177956_o());
                maxZ = Math.max(maxZ, pos.func_177952_p());
            }
            buffer.func_179255_a(new BlockPos(minX, minY, minZ));
            buffer.func_179255_a(new BlockPos(maxX + 1, maxY + 1, maxZ + 1));
        }
    }

    protected void readState(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            this.state = new MultiblockState(this.field_145850_b, this.field_174879_c);
            this.state.setError(null);
            int size = buffer.func_150792_a();
            if (size > 0) {
                ImmutableList.Builder listBuilder = new ImmutableList.Builder();
                for (int i = size; i > 0; --i) {
                    listBuilder.add((Object)BlockPos.func_177969_a((long)buffer.readLong()));
                }
                MultiblockWorldSavedData.addDisableModel(this.state.controllerPos, (Collection<BlockPos>)listBuilder.build());
            }
            this.renderBox = new AxisAlignedBB(buffer.func_179259_c(), buffer.func_179259_c());
        } else {
            if (this.state != null) {
                MultiblockWorldSavedData.removeDisableModel(this.state.controllerPos);
            }
            this.state = null;
            this.renderBox = null;
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        block9: {
            try {
                super.func_145839_a(compound);
            }
            catch (Exception e) {
                if (this.definition != null) break block9;
                MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(this.field_145850_b);
                if (this.field_174879_c != null && mwsd.mapping.containsKey(this.field_174879_c)) {
                    mwsd.removeMapping(mwsd.mapping.get(this.field_174879_c));
                }
                return;
            }
        }
        if (compound.func_74764_b("ars")) {
            this.asyncRecipeSearching = compound.func_74767_n("ars");
        }
        if (compound.func_74764_b("recipeLogic")) {
            this.recipeLogic = new RecipeLogic(this);
            this.recipeLogic.readFromNBT(compound.func_74775_l("recipeLogic"));
            this.status = this.recipeLogic.getStatus().name;
        }
        if (compound.func_74764_b("capabilities")) {
            NBTTagList tagList = compound.func_150295_c("capabilities", 10);
            this.settings = new HashMap();
            for (NBTBase base : tagList) {
                NBTTagCompound tag = (NBTTagCompound)base;
                this.settings.computeIfAbsent(tag.func_74763_f("pos"), l -> new HashMap()).put(MbdCapabilities.get(tag.func_74779_i("cap")), new Tuple((Object)IO.VALUES[tag.func_74762_e("io")], (Object)EnumFacing.field_82609_l[tag.func_74762_e("facing")]));
            }
        }
        if (((ControllerDefinition)this.getDefinition()).noNeedController && compound.func_74764_b("oldState")) {
            this.oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("oldState"));
            if (compound.func_74764_b("oldNbt")) {
                this.oldNbt = compound.func_74775_l("oldNbt");
            }
        }
        this.state = MultiblockWorldSavedData.getOrCreate((World)this.field_145850_b).mapping.get(this.field_174879_c);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.asyncRecipeSearching) {
            compound.func_74757_a("ars", false);
        }
        if (this.recipeLogic != null) {
            compound.func_74782_a("recipeLogic", (NBTBase)this.recipeLogic.writeToNBT(new NBTTagCompound()));
        }
        if (this.capabilities != null) {
            NBTTagList tagList = new NBTTagList();
            for (Table.Cell cell : this.capabilities.cellSet()) {
                IO io = (IO)((Object)cell.getRowKey());
                MultiblockCapability cap = (MultiblockCapability)cell.getColumnKey();
                Long2ObjectOpenHashMap value = (Long2ObjectOpenHashMap)cell.getValue();
                if (io == null || cap == null || value == null) continue;
                for (Map.Entry entry : value.entrySet()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74768_a("io", io.ordinal());
                    tag.func_74768_a("facing", ((CapabilityProxy)entry.getValue()).facing.func_176745_a());
                    tag.func_74778_a("cap", cap.name);
                    tag.func_74772_a("pos", ((Long)entry.getKey()).longValue());
                    tagList.func_74742_a((NBTBase)tag);
                }
            }
            compound.func_74782_a("capabilities", (NBTBase)tagList);
        }
        if (((ControllerDefinition)this.getDefinition()).noNeedController && this.oldState != null) {
            compound.func_74782_a("oldState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.oldState));
            if (this.oldNbt != null) {
                compound.func_74782_a("oldNbt", (NBTBase)this.oldNbt);
            }
        }
        return compound;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((ControllerDefinition)this.definition).onRightClick != null) {
            try {
                if (((ControllerDefinition)this.definition).onRightClick.apply(this, CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIFacing((EnumFacing)facing), hitX, hitY, hitZ)) {
                    return true;
                }
            }
            catch (Exception exception) {
                ((ControllerDefinition)this.definition).onRightClick = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ControllerDefinition)this.definition).location, (Object)"onRightClick", (Object)exception);
            }
        }
        if (this.func_145831_w().field_72995_K && !this.isFormed() && player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
            MultiblockPreviewRenderer.renderMultiBlockPreview(this, 60000L);
            return true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isFormed() && ((ControllerDefinition)this.definition).getCatalyst() != null) {
                if (this.state == null) {
                    this.state = new MultiblockState(this.field_145850_b, this.field_174879_c);
                }
                ItemStack held = player.func_184586_b(hand);
                if ((((ControllerDefinition)this.definition).getCatalyst().func_190926_b() || ItemStack.func_185132_d((ItemStack)held, (ItemStack)((ControllerDefinition)this.definition).getCatalyst())) && this.checkCatalystPattern(player, hand, held)) {
                    return true;
                }
            }
            if (!player.func_70093_af() && !this.field_145850_b.field_72995_K && player instanceof EntityPlayerMP) {
                TileEntityUIFactory.INSTANCE.openUI(this, (EntityPlayerMP)player);
            }
        }
        return true;
    }

    public boolean checkCatalystPattern(EntityPlayer player, EnumHand hand, ItemStack held) {
        if (this.checkPattern()) {
            if (!player.func_184812_l_() && !((ControllerDefinition)this.getDefinition()).consumeCatalyst.test(held)) {
                this.state.setError(new PatternStringError("catalyst failed"));
                return false;
            }
            player.func_184609_a(hand);
            ITextComponent formedMsg = new TextComponentTranslation(this.getUnlocalizedName(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("multiblocked.multiblock.formed", new Object[0]));
            player.func_146105_b(formedMsg, true);
            MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addMapping(this.state);
            if (!this.needAlwaysUpdate()) {
                MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addLoading(this);
            }
            this.onStructureFormed();
            return true;
        }
        return false;
    }

    @Override
    public ModularUI createUI(EntityPlayer entityPlayer) {
        TabContainer tabContainer = new TabContainer(0, 0, 200, 232);
        if (!this.traits.isEmpty()) {
            this.initTraitUI(tabContainer, entityPlayer);
        }
        if (this.isFormed()) {
            new RecipePage(this, tabContainer);
            new IOPageWidget(this, tabContainer);
        } else {
            new StructurePageWidget((ControllerDefinition)this.definition, tabContainer);
        }
        return new ModularUIBuilder(IGuiTexture.EMPTY, 196, 256).widget(tabContainer).build(this, entityPlayer);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getRenderer().isGlobalRenderer(this) ? INFINITE_EXTENT_AABB : (this.renderBox == null ? super.getRenderBoundingBox() : this.renderBox);
    }

    @Override
    public void asyncThreadLogic(long periodID) {
        if (!this.isFormed() && ((ControllerDefinition)this.getDefinition()).getCatalyst() == null && ((long)this.getOffset() + periodID) % 4L == 0L && this.getPattern().checkPatternAt(new MultiblockState(this.field_145850_b, this.field_174879_c), false)) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> {
                if (this.state == null) {
                    this.state = new MultiblockState(this.field_145850_b, this.field_174879_c);
                }
                if (this.shouldCheckPattern() && this.checkPattern()) {
                    MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addMapping(this.state);
                    this.onStructureFormed();
                }
            });
        }
        try {
            if (this.hasProxies()) {
                for (Long2ObjectOpenHashMap map : this.getCapabilities().values()) {
                    if (map == null) continue;
                    for (CapabilityProxy proxy : map.values()) {
                        if (proxy == null) continue;
                        proxy.updateChangedState(periodID);
                    }
                }
            }
        }
        catch (Exception e) {
            Multiblocked.LOGGER.error("something run while checking proxy changes");
        }
    }

    public void saveOldBlock(IBlockState oldState, NBTTagCompound oldNbt) {
        this.oldState = oldState;
        if (oldNbt != null) {
            this.oldNbt = oldNbt;
        }
        this.markAsDirty();
    }
}

