/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.tile;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IInnerCapabilityProvider;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.capability.trait.CapabilityTrait;
import com.cleanroommc.multiblocked.api.capability.trait.InterfaceUser;
import com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTComponent;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.gui.factory.TileEntityUIFactory;
import com.cleanroommc.multiblocked.api.gui.modular.IUIHolder;
import com.cleanroommc.multiblocked.api.gui.modular.ModularUI;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.util.ModularUIBuilder;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.ImageWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SlotWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabButton;
import com.cleanroommc.multiblocked.api.gui.widget.imp.tab.TabContainer;
import com.cleanroommc.multiblocked.api.registry.MbdCapabilities;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.api.tile.IDynamicComponentTile;
import com.cleanroommc.multiblocked.client.renderer.IRenderer;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import com.cleanroommc.multiblocked.util.world.DummyWorld;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="crafttweaker", iface="com.cleanroommc.multiblocked.api.crafttweaker.interfaces.ICTComponent")
public abstract class ComponentTileEntity<T extends ComponentDefinition>
extends TileEntity
implements IUIHolder,
ICTComponent,
IInnerCapabilityProvider {
    protected T definition;
    protected IRenderer currentRenderer;
    public Object persistentData;
    public Object rendererObject;
    private EnumFacing frontFacing = EnumFacing.NORTH;
    private UUID owner;
    private final int offset;
    private int timer = this.offset = Multiblocked.RNG.nextInt();
    protected String status = "unformed";
    protected Map<MultiblockCapability<?>, CapabilityTrait> traits = new HashMap();
    protected final List<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();

    public void setDefinition(ComponentDefinition definition) {
        this.definition = definition;
        for (Map.Entry entry : ((ComponentDefinition)this.definition).traits.entrySet()) {
            MultiblockCapability<?> capability = MbdCapabilities.get((String)entry.getKey());
            if (capability == null || !capability.hasTrait()) continue;
            CapabilityTrait trait = capability.createTrait();
            trait.serialize((JsonElement)entry.getValue());
            trait.setComponent(this);
            this.traits.put(capability, trait);
        }
        if (this instanceof IDynamicComponentTile) {
            IDynamicComponentTile dynamicComponentTile = (IDynamicComponentTile)((Object)this);
            Map traitSetters = dynamicComponentTile.getTraitSetters();
            for (CapabilityTrait trait : this.traits.values()) {
                Class<?> traitClass = trait.getClass();
                if (!traitClass.isAnnotationPresent(InterfaceUser.class)) continue;
                traitSetters.get(traitClass.getAnnotation(InterfaceUser.class).value().getSimpleName()).accept(this, trait);
            }
        }
    }

    public boolean needAlwaysUpdate() {
        return this.field_145850_b != null && !this.isRemote() && (((ComponentDefinition)this.definition).needUpdateTick() || this.traits.values().stream().anyMatch(CapabilityTrait::hasUpdate));
    }

    public boolean hasTrait(MultiblockCapability<?> capability) {
        return this.traits.get(capability) != null;
    }

    public CapabilityTrait getTrait(MultiblockCapability<?> capability) {
        return this.traits.get(capability);
    }

    @Override
    public ComponentTileEntity<?> getInner() {
        return this;
    }

    public T getDefinition() {
        return this.definition;
    }

    public ResourceLocation getLocation() {
        return ((ComponentDefinition)this.definition).location;
    }

    @Override
    public String getUnlocalizedName() {
        return "tile." + this.getLocation().func_110624_b() + "." + this.getLocation().func_110623_a() + ".name";
    }

    @Override
    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public abstract boolean isFormed();

    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getTimer() {
        return this.timer;
    }

    public UUID getOwnerUUID() {
        return this.owner;
    }

    @Nullable
    public EntityPlayer getOwner() {
        return this.owner == null ? null : this.field_145850_b.func_152378_a(this.owner);
    }

    public void setOwner(UUID player) {
        this.owner = player;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player.func_110124_au();
    }

    @Override
    public void update() {
        ++this.timer;
        if (((ComponentDefinition)this.definition).updateTick != null) {
            try {
                ((ComponentDefinition)this.definition).updateTick.apply(this);
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).updateTick = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"updateTick", (Object)exception);
            }
        }
        if (!this.traits.isEmpty()) {
            for (CapabilityTrait trait : this.traits.values()) {
                trait.update();
            }
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        if (!(this.isRemote() && !(this.field_145850_b instanceof DummyWorld) || this.status.equals(status))) {
            if (((ComponentDefinition)this.definition).statusChanged != null) {
                try {
                    status = ((ComponentDefinition)this.definition).statusChanged.apply(this, status);
                }
                catch (Exception exception) {
                    ((ComponentDefinition)this.definition).statusChanged = null;
                    Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"statusChanged", (Object)exception);
                }
            }
            boolean shouldUpdateLight = ((ComponentDefinition)this.getDefinition()).getStatus(status).getLightEmissive() != ((ComponentDefinition)this.getDefinition()).getStatus(this.status).getLightEmissive();
            this.status = status;
            if (shouldUpdateLight) {
                this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            }
            this.writeCustomData(1, buffer -> buffer.func_180714_a(this.status));
        }
    }

    public List<AxisAlignedBB> getCollisionBoundingBox() {
        return ((ComponentDefinition)this.definition).getStatus(this.getStatus()).getShape(this.frontFacing);
    }

    public EnumFacing getFrontFacing() {
        return this.frontFacing;
    }

    public boolean setFrontFacing(EnumFacing facing) {
        if (!this.isValidFrontFacing(facing)) {
            return false;
        }
        this.frontFacing = facing;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.markAsDirty();
            this.writeCustomData(0, buffer -> buffer.writeByte(this.frontFacing.func_176745_a()));
        }
        return true;
    }

    public void func_189667_a(@Nonnull Rotation rotationIn) {
        this.setFrontFacing(rotationIn.func_185831_a(this.getFrontFacing()));
    }

    public void func_189668_a(@Nonnull Mirror mirrorIn) {
        this.func_189667_a(mirrorIn.func_185800_a(this.getFrontFacing()));
    }

    public IRenderer updateCurrentRenderer() {
        if (((ComponentDefinition)this.definition).dynamicRenderer != null) {
            try {
                return ((ComponentDefinition)this.definition).dynamicRenderer.apply(this);
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).dynamicRenderer = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"dynamicRenderer", (Object)exception);
            }
        }
        return ((ComponentDefinition)this.getDefinition()).getStatus(this.getStatus()).getRenderer();
    }

    @Override
    public IRenderer getRenderer() {
        IRenderer lastRenderer = this.currentRenderer;
        this.currentRenderer = this.updateCurrentRenderer();
        if (lastRenderer != this.currentRenderer && Multiblocked.isClient()) {
            if (lastRenderer != null) {
                lastRenderer.onPostAccess(this);
            }
            if (this.currentRenderer != null) {
                this.currentRenderer.onPreAccess(this);
            }
        }
        return this.currentRenderer;
    }

    public boolean isValidFrontFacing(EnumFacing facing) {
        return ((ComponentDefinition)this.getDefinition()).properties.rotationState.test(facing);
    }

    public boolean canConnectRedstone(EnumFacing facing) {
        return ((ComponentDefinition)this.definition).getOutputRedstoneSignal != null;
    }

    public int getOutputRedstoneSignal(EnumFacing facing) {
        if (((ComponentDefinition)this.definition).getOutputRedstoneSignal != null) {
            try {
                return ((ComponentDefinition)this.definition).getOutputRedstoneSignal.apply(this, CraftTweakerMC.getIFacing((EnumFacing)facing));
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).getOutputRedstoneSignal = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"getOutputRedstoneSignal", (Object)exception);
            }
        }
        return 0;
    }

    @Override
    public void scheduleChunkForRenderUpdate() {
        BlockPos pos = this.func_174877_v();
        this.func_145831_w().func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
    }

    @Override
    public void notifyBlockUpdate() {
        this.func_145831_w().func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    @Override
    public void markAsDirty() {
        super.func_70296_d();
    }

    public boolean shouldRenderInPass(int pass) {
        IRenderer renderer = this.getRenderer();
        return renderer != null && renderer.shouldRenderInPass(this.field_145850_b, this.field_174879_c, pass);
    }

    public boolean hasTESRRenderer() {
        IRenderer renderer = this.getRenderer();
        return renderer != null && renderer.hasTESR(this.func_145831_w(), this.func_174877_v());
    }

    public void onDrops(NonNullList<ItemStack> drops, EntityPlayer player) {
        if (((ComponentDefinition)this.definition).onDrops != null) {
            try {
                for (IItemStack drop : ((ComponentDefinition)this.definition).onDrops.apply(this, CraftTweakerMC.getIPlayer((EntityPlayer)player))) {
                    drops.add((Object)CraftTweakerMC.getItemStack((IItemStack)drop));
                }
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).onDrops = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"onDrops", (Object)exception);
            }
        }
        for (CapabilityTrait trait : this.traits.values()) {
            trait.onDrops(drops, player);
        }
        drops.add((Object)((ComponentDefinition)this.definition).getStackForm());
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((ComponentDefinition)this.definition).onRightClick != null) {
            try {
                if (((ComponentDefinition)this.definition).onRightClick.apply(this, CraftTweakerMC.getIPlayer((EntityPlayer)player), CraftTweakerMC.getIFacing((EnumFacing)facing), hitX, hitY, hitZ)) {
                    return true;
                }
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).onRightClick = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"onRightClick", (Object)exception);
            }
        }
        if (!player.func_70093_af()) {
            if (!this.field_145850_b.field_72995_K && player instanceof EntityPlayerMP) {
                return TileEntityUIFactory.INSTANCE.openUI(this, (EntityPlayerMP)player);
            }
            return !this.traits.isEmpty();
        }
        return false;
    }

    public void onLeftClick(EntityPlayer player) {
        if (((ComponentDefinition)this.definition).onLeftClick != null) {
            try {
                ((ComponentDefinition)this.definition).onLeftClick.apply(this, CraftTweakerMC.getIPlayer((EntityPlayer)player));
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).onLeftClick = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"onLeftClick", (Object)exception);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        this.traits.values().forEach(CapabilityTrait::onLoad);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.traits.values().forEach(CapabilityTrait::onChunkUnload);
    }

    public boolean func_145842_c(int id, int type) {
        boolean result = false;
        for (CapabilityTrait trait : this.traits.values()) {
            result |= trait.receiveClientEvent(id, type);
        }
        return result;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.traits.values().forEach(CapabilityTrait::validate);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.traits.values().forEach(CapabilityTrait::invalidate);
    }

    public void onNeighborChanged() {
        this.traits.values().forEach(CapabilityTrait::onNeighborChanged);
        if (((ComponentDefinition)this.definition).onNeighborChanged != null) {
            try {
                ((ComponentDefinition)this.definition).onNeighborChanged.apply(this);
            }
            catch (Exception exception) {
                ((ComponentDefinition)this.definition).onNeighborChanged = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"onNeighborChanged", (Object)exception);
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.traits.values().stream().anyMatch(trait -> trait.hasCapability(capability, facing));
    }

    @Nullable
    public <K> K getCapability(@Nonnull Capability<K> capability, @Nullable EnumFacing facing) {
        for (CapabilityTrait trait : this.traits.values()) {
            K result = trait.getCapability(capability, facing);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public <K> K getInnerCapability(@Nonnull Capability<K> capability, @Nullable EnumFacing facing, @Nullable String slotNam) {
        for (CapabilityTrait trait : this.traits.values()) {
            K result = trait.getInnerCapability(capability, facing, slotNam);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Set<String> getSlotNames() {
        HashSet<String> result = new HashSet<String>();
        for (CapabilityTrait trait : this.traits.values()) {
            result.addAll(trait.getSlotNames());
        }
        return result;
    }

    @Override
    public final boolean isRemote() {
        return this.field_145850_b == null ? Multiblocked.isClient() : this.field_145850_b.field_72995_K;
    }

    @Override
    public ModularUI createUI(EntityPlayer entityPlayer) {
        if (this.traits.isEmpty()) {
            return null;
        }
        TabContainer tabContainer = new TabContainer(0, 0, 200, 232);
        this.initTraitUI(tabContainer, entityPlayer);
        return new ModularUIBuilder(IGuiTexture.EMPTY, 196, 256).widget(tabContainer).build(this, entityPlayer);
    }

    protected void initTraitUI(TabContainer tabContainer, EntityPlayer entityPlayer) {
        WidgetGroup group = new WidgetGroup(20, 0, 176, 256);
        tabContainer.addTab(new TabButton(0, tabContainer.containerGroup.widgets.size() * 20, 20, 20).setTexture(new ResourceTexture("multiblocked:textures/gui/custom_gui_tab_button.png").getSubTexture(0.0, 0.0, 1.0, 0.5), new ResourceTexture("multiblocked:textures/gui/custom_gui_tab_button.png").getSubTexture(0.0, 0.5, 1.0, 0.5)), group);
        group.addWidget(new ImageWidget(0, 0, 176, 256, new ResourceTexture(JsonUtils.func_151219_a((JsonObject)((ComponentDefinition)this.definition).traits, (String)"background", (String)"multiblocked:textures/gui/custom_gui.png"))));
        if (this.traits.size() > 0) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 9; ++col) {
                    group.addWidget(new SlotWidget((IInventory)entityPlayer.field_71071_by, col + (row + 1) * 9, 7 + col * 18, 173 + row * 18).setLocationInfo(true, false));
                }
            }
            for (int slot = 0; slot < 9; ++slot) {
                group.addWidget(new SlotWidget((IInventory)entityPlayer.field_71071_by, slot, 7 + slot * 18, 231).setLocationInfo(true, true));
            }
        }
        for (CapabilityTrait trait : this.traits.values()) {
            trait.createUI(this, group, entityPlayer);
        }
    }

    public final void writeTraitData(CapabilityTrait trait, int internalId, Consumer<PacketBuffer> dataWriter) {
        this.writeCustomData(3, buffer -> {
            buffer.func_180714_a(trait.capability.name);
            buffer.func_150787_b(internalId);
            dataWriter.accept((PacketBuffer)buffer);
        });
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        block5: {
            buf.func_180714_a(this.getLocation().toString());
            buf.writeByte(this.frontFacing.func_176745_a());
            buf.func_180714_a(this.status);
            if (((ComponentDefinition)this.definition).writeInitialData != null) {
                try {
                    IData data = ((ComponentDefinition)this.definition).writeInitialData.apply(this);
                    if (data != null) {
                        buf.writeBoolean(true);
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74782_a("data", CraftTweakerMC.getNBT((IData)data));
                        buf.func_150786_a(tag);
                        break block5;
                    }
                    buf.writeBoolean(false);
                }
                catch (Exception exception) {
                    ((ComponentDefinition)this.definition).writeInitialData = null;
                    Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"writeInitialData", (Object)exception);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        this.setDefinition((ComponentDefinition)MbdComponents.DEFINITION_REGISTRY.get((Object)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE))));
        this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
        String status = buf.func_150789_c(Short.MAX_VALUE);
        if (!this.status.equals(status)) {
            this.status = status;
            if (((ComponentDefinition)this.getDefinition()).getStatus((String)status).getSound().loop) {
                ((ComponentDefinition)this.getDefinition()).getStatus(status).getSound().playSound(this);
            }
        }
        if (buf.readBoolean()) {
            try {
                NBTTagCompound nbt = buf.func_150793_b();
                if (nbt != null && ((ComponentDefinition)this.definition).readInitialData != null) {
                    try {
                        ((ComponentDefinition)this.definition).readInitialData.apply(this, CraftTweakerMC.getIData((NBTBase)nbt.func_74781_a("data")));
                    }
                    catch (Exception exception) {
                        ((ComponentDefinition)this.definition).readInitialData = null;
                        Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"readInitialData", (Object)exception);
                    }
                }
            }
            catch (IOException e) {
                Multiblocked.LOGGER.error("handling ct initial data error");
            }
        }
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        block13: {
            MultiblockCapability<?> capability;
            if (dataId == 0) {
                this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
                this.scheduleChunkForRenderUpdate();
            } else if (dataId == 1) {
                String status = buf.func_150789_c(Short.MAX_VALUE);
                if (!this.status.equals(status)) {
                    boolean shouldUpdateLight = ((ComponentDefinition)this.getDefinition()).getStatus(status).getLightEmissive() != ((ComponentDefinition)this.getDefinition()).getStatus(this.status).getLightEmissive();
                    this.status = status;
                    ((ComponentDefinition)this.getDefinition()).getStatus(status).getSound().playSound(this);
                    if (shouldUpdateLight) {
                        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
                    }
                }
                this.scheduleChunkForRenderUpdate();
            } else if (dataId == 2) {
                int id = buf.func_150792_a();
                try {
                    NBTTagCompound nbt = buf.func_150793_b();
                    if (nbt == null || ((ComponentDefinition)this.definition).receiveCustomData == null) break block13;
                    try {
                        ((ComponentDefinition)this.definition).receiveCustomData.apply(this, id, CraftTweakerMC.getIData((NBTBase)nbt.func_74781_a("data")));
                    }
                    catch (Exception exception) {
                        ((ComponentDefinition)this.definition).receiveCustomData = null;
                        Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)((ComponentDefinition)this.definition).location, (Object)"receiveCustomData", (Object)exception);
                    }
                }
                catch (IOException e) {
                    Multiblocked.LOGGER.error("handling ct custom data error id:{}", (Object)id);
                }
            } else if (dataId == 3 && this.traits.containsKey(capability = MbdCapabilities.get(buf.func_150789_c(Short.MAX_VALUE)))) {
                this.traits.get(capability).receiveCustomData(buf.func_150792_a(), buf);
            }
        }
    }

    public final void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
    }

    public final NBTTagCompound serializeNBT() {
        return super.serializeNBT();
    }

    protected final void func_190201_b(@Nonnull World worldIn) {
        this.func_145834_a(worldIn);
    }

    public void func_174878_a(@Nonnull BlockPos pos) {
        super.func_174878_a(pos);
        if (this.needAlwaysUpdate()) {
            MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addLoading(this);
        }
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        try {
            this.setDefinition((ComponentDefinition)MbdComponents.DEFINITION_REGISTRY.get((Object)new ResourceLocation(compound.func_74779_i("loc"))));
        }
        catch (Exception e) {
            if (this.definition == null) {
                this.func_145831_w().func_175698_g(this.func_174877_v());
                this.func_145831_w().func_175690_a(this.func_174877_v(), null);
                throw new IllegalStateException("null definition set: " + compound.func_74779_i("loc"));
            }
            throw e;
        }
        if (this.needAlwaysUpdate()) {
            MultiblockWorldSavedData.getOrCreate(this.field_145850_b).addLoading(this);
        }
        EnumFacing enumFacing = this.frontFacing = compound.func_74764_b("frontFacing") ? EnumFacing.func_82600_a((int)compound.func_74771_c("frontFacing")) : this.frontFacing;
        if (compound.func_186855_b("owner")) {
            this.owner = compound.func_186857_a("owner");
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            this.persistentData = CraftTweakerMC.getIData((NBTBase)compound.func_74781_a("ct_persistent"));
        }
        NBTTagCompound traitTag = compound.func_74775_l("trait");
        for (Map.Entry<MultiblockCapability<?>, CapabilityTrait> entry : this.traits.entrySet()) {
            entry.getValue().readFromNBT(traitTag.func_74775_l(entry.getKey().name));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("loc", ((ComponentDefinition)this.definition).location.toString());
        compound.func_74774_a("frontFacing", (byte)this.frontFacing.func_176745_a());
        if (this.owner != null) {
            compound.func_186854_a("owner", this.owner);
        }
        compound.func_74778_a("mbd_def", ((ComponentDefinition)this.definition).location.toString());
        if (Loader.isModLoaded((String)"crafttweaker") && this.persistentData instanceof IData) {
            compound.func_74782_a("ct_persistent", CraftTweakerMC.getNBT((IData)((IData)this.persistentData)));
        }
        NBTTagCompound traitTag = new NBTTagCompound();
        for (Map.Entry<MultiblockCapability<?>, CapabilityTrait> entry : this.traits.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            entry.getValue().writeToNBT(tag);
            traitTag.func_74782_a(entry.getKey().name, (NBTBase)tag);
        }
        compound.func_74782_a("trait", (NBTBase)traitTag);
        return compound;
    }

    public void writeCustomData(int discriminator, Consumer<PacketBuffer> dataWriter) {
        ByteBuf backedBuffer = Unpooled.buffer();
        dataWriter.accept(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        this.updateEntries.add(new UpdateEntry(discriminator, updateData));
        IBlockState blockState = this.func_145838_q().func_176203_a(this.func_145832_p());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 0);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (UpdateEntry updateEntry : this.updateEntries) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74768_a("i", updateEntry.discriminator);
            entryTag.func_74773_a("d", updateEntry.updateData);
            tagList.func_74742_a((NBTBase)entryTag);
        }
        this.updateEntries.clear();
        updateTag.func_74782_a("d", (NBTBase)tagList);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTag = pkt.func_148857_g();
        NBTTagList tagList = updateTag.func_150295_c("d", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = tagList.func_150305_b(i);
            int discriminator = entryTag.func_74762_e("i");
            byte[] updateData = entryTag.func_74770_j("d");
            ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
            this.receiveCustomData(discriminator, new PacketBuffer(backedBuffer));
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        ByteBuf backedBuffer = Unpooled.buffer();
        this.writeInitialSyncData(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        updateTag.func_74773_a("d", updateData);
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        byte[] updateData = tag.func_74770_j("d");
        ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
        this.receiveInitialSyncData(new PacketBuffer(backedBuffer));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getRenderer().isGlobalRenderer(this) ? INFINITE_EXTENT_AABB : super.getRenderBoundingBox();
    }

    private static class UpdateEntry {
        private final int discriminator;
        private final byte[] updateData;

        public UpdateEntry(int discriminator, byte[] updateData) {
            this.discriminator = discriminator;
            this.updateData = updateData;
        }
    }
}

