/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.sound;

import com.cleanroommc.multiblocked.api.sound.ComponentSound;
import com.cleanroommc.multiblocked.api.tile.ComponentTileEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SoundState {
    public static final SoundState EMPTY = new SoundState(new ResourceLocation("multiblocked:empty"));
    private transient boolean init;
    private transient SoundEvent soundEvent;
    public transient String status;
    public final ResourceLocation sound;
    public boolean loop;
    public int delay;
    public float volume;
    public float pitch;

    public SoundState(ResourceLocation sound) {
        this.sound = sound;
        this.loop = false;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
    }

    public SoundState copy(ResourceLocation sound) {
        SoundState soundState = new SoundState(sound);
        soundState.loop = this.loop;
        soundState.delay = this.delay;
        soundState.volume = this.volume;
        soundState.pitch = this.pitch;
        return soundState;
    }

    public SoundState copy() {
        if (this == EMPTY) {
            return EMPTY;
        }
        return this.copy(this.sound);
    }

    @Nullable
    public SoundEvent getSoundEvent() {
        if (this == EMPTY) {
            return null;
        }
        if (this.soundEvent == null && !this.init) {
            this.init = true;
            this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.sound);
        }
        return this.soundEvent;
    }

    @SideOnly(value=Side.CLIENT)
    public ComponentSound playGUISound() {
        if (this == EMPTY) {
            return null;
        }
        SoundEvent sound = this.getSoundEvent();
        ComponentSound componentSound = null;
        if (sound != null) {
            componentSound = new ComponentSound(sound, this, null);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)componentSound);
        }
        return componentSound;
    }

    @SideOnly(value=Side.CLIENT)
    public ComponentSound playSound(ComponentTileEntity<?> component) {
        if (this == EMPTY) {
            return null;
        }
        SoundEvent sound = this.getSoundEvent();
        ComponentSound componentSound = null;
        if (sound != null) {
            componentSound = new ComponentSound(sound, this, component);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)componentSound);
        }
        return componentSound;
    }

    public boolean playLevelSound(World level, BlockPos pos) {
        if (this == EMPTY) {
            return false;
        }
        SoundEvent sound = this.getSoundEvent();
        if (sound == null) {
            return false;
        }
        level.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, this.volume, this.pitch);
        return true;
    }
}

