/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.registry;

import com.cleanroommc.multiblocked.api.recipe.RecipeCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.BiomeCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.BlockCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.DimensionCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.PositionYCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.PredicateCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.RainingCondition;
import com.cleanroommc.multiblocked.common.recipe.conditions.ThunderCondition;
import com.google.common.collect.Maps;
import java.util.Map;

public class MbdRecipeConditions {
    public static final Map<String, RecipeCondition> RECIPE_CONDITIONS_REGISTRY = Maps.newHashMap();

    public static void registerCondition(RecipeCondition condition) {
        RECIPE_CONDITIONS_REGISTRY.put(condition.getType().toLowerCase(), condition);
    }

    public static RecipeCondition getCondition(String type) {
        return RECIPE_CONDITIONS_REGISTRY.get(type.toLowerCase());
    }

    public static void registerConditions() {
        MbdRecipeConditions.registerCondition(DimensionCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(ThunderCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(RainingCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(PositionYCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(BiomeCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(BlockCondition.INSTANCE);
        MbdRecipeConditions.registerCondition(PredicateCondition.INSTANCE);
    }
}

