/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.registry;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateAnyCapability;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateBlocks;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateComponent;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateCustomAny;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateMetaTileEntity;
import com.cleanroommc.multiblocked.api.pattern.predicates.PredicateStates;
import com.cleanroommc.multiblocked.api.pattern.predicates.SimplePredicate;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class MbdPredicates {
    public static final Map<String, Class<? extends SimplePredicate>> PREDICATE_REGISTRY = Maps.newHashMap();

    public static void registerPredicate(Class<? extends SimplePredicate> predicate) {
        try {
            PREDICATE_REGISTRY.put(predicate.newInstance().type, predicate);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Multiblocked.LOGGER.error("Registered predicates require a parameterless constructor");
        }
    }

    private static Class<? extends SimplePredicate> getPredicate(String type) {
        return PREDICATE_REGISTRY.get(type.toLowerCase());
    }

    public static SimplePredicate createPredicate(String type) {
        return MbdPredicates.createPredicate(type, null);
    }

    public static SimplePredicate createPredicate(String type, JsonObject json) {
        if (type.equals("any")) {
            return SimplePredicate.ANY;
        }
        if (type.equals("air")) {
            return SimplePredicate.AIR;
        }
        Class<? extends SimplePredicate> clazz = MbdPredicates.getPredicate(type);
        if (clazz != null) {
            try {
                SimplePredicate simplePredicate = clazz.newInstance();
                if (json == null) {
                    return simplePredicate.buildPredicate();
                }
                simplePredicate.fromJson(Multiblocked.GSON, json);
                simplePredicate.buildPredicate();
                return simplePredicate;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void registerPredicates() {
        MbdPredicates.registerPredicate(PredicateComponent.class);
        MbdPredicates.registerPredicate(PredicateStates.class);
        MbdPredicates.registerPredicate(PredicateBlocks.class);
        MbdPredicates.registerPredicate(PredicateAnyCapability.class);
        MbdPredicates.registerPredicate(PredicateCustomAny.class);
        if (Loader.isModLoaded((String)"gregtech") && MbdPredicates.isCEu()) {
            MbdPredicates.registerPredicate(PredicateMetaTileEntity.class);
        }
    }

    public static boolean isCEu() {
        String version = ((ModContainer)Loader.instance().getIndexedModList().get("gregtech")).getVersion();
        return Integer.parseInt(version.split("\\.")[0]) >= 2;
    }
}

