/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.registry;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.block.ItemComponent;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.definition.ComponentDefinition;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.pattern.util.BlockInfo;
import com.cleanroommc.multiblocked.api.tile.DummyComponentTileEntity;
import com.cleanroommc.multiblocked.jei.multipage.MultiblockInfoCategory;
import com.cleanroommc.multiblocked.util.FileUtility;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class MbdComponents {
    public static final Set<Class<? extends TileEntity>> CLASS_SET = new HashSet<Class<? extends TileEntity>>();
    public static final BiMap<ResourceLocation, ComponentDefinition> DEFINITION_REGISTRY = HashBiMap.create();
    public static final BiMap<ResourceLocation, BlockComponent> COMPONENT_BLOCKS_REGISTRY = HashBiMap.create();
    public static final BiMap<ResourceLocation, ItemComponent> COMPONENT_ITEMS_REGISTRY = HashBiMap.create();
    public static final Map<ItemStack, ControllerDefinition[]> NO_NEED_CONTROLLER_MB = new HashMap<ItemStack, ControllerDefinition[]>();
    public static final Set<Item> CATALYST_SET = new HashSet<Item>();
    public static final BlockComponent DummyComponentBlock;
    public static final ItemComponent DummyComponentItem;
    public static List<Runnable> handlers;

    public static void registerComponent(ComponentDefinition definition) {
        if (DEFINITION_REGISTRY.containsKey((Object)definition.location)) {
            return;
        }
        DEFINITION_REGISTRY.put((Object)definition.location, (Object)definition);
        COMPONENT_ITEMS_REGISTRY.computeIfAbsent((Object)definition.location, x -> new ItemComponent((BlockComponent)COMPONENT_BLOCKS_REGISTRY.computeIfAbsent((Object)definition.location, X -> new BlockComponent(definition))));
        if (definition instanceof ControllerDefinition && Loader.isModLoaded((String)"jei")) {
            MultiblockInfoCategory.registerMultiblock((ControllerDefinition)definition);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        COMPONENT_BLOCKS_REGISTRY.values().forEach(BlockComponent::onModelRegister);
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        COMPONENT_BLOCKS_REGISTRY.values().forEach(arg_0 -> registry.register(arg_0));
        for (ComponentDefinition definition : DEFINITION_REGISTRY.values()) {
            if (CLASS_SET.contains(definition.clazz)) continue;
            GameRegistry.registerTileEntity(definition.clazz, (ResourceLocation)definition.location);
            CLASS_SET.add(definition.clazz);
        }
    }

    public static <T extends ComponentDefinition> void registerComponentFromFile(File location, Class<T> clazz, BiConsumer<T, JsonObject> postHandler) {
        for (File file : Optional.ofNullable(location.listFiles((f, n) -> n.endsWith(".json"))).orElse(new File[0])) {
            try {
                JsonObject config = (JsonObject)FileUtility.loadJson(file);
                Constructor constructor = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> {
                    if (c.getParameterCount() != 1) {
                        return false;
                    }
                    Class<?>[] classes = c.getParameterTypes();
                    return ResourceLocation.class.isAssignableFrom(classes[0]);
                }).findFirst().orElseThrow(() -> new IllegalArgumentException("cant find the constructor with the parameters(resourcelocation)"));
                ComponentDefinition definition = (ComponentDefinition)constructor.newInstance(new ResourceLocation(config.get("location").getAsString()));
                definition.fromJson(config);
                MbdComponents.registerComponent(definition);
                if (postHandler == null) continue;
                handlers.add(() -> postHandler.accept(definition, config));
            }
            catch (Exception e) {
                Multiblocked.LOGGER.error("error while loading the definition file {}", (Object)file.toString());
            }
        }
    }

    public static void executeInitHandler() {
        handlers.forEach(Runnable::run);
        handlers.clear();
    }

    public static void registerNoNeedController(ItemStack catalyst, ControllerDefinition definition) {
        CATALYST_SET.add(catalyst.func_77973_b());
        ItemStack key = catalyst;
        for (ItemStack itemStack : NO_NEED_CONTROLLER_MB.keySet()) {
            if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)catalyst) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)catalyst)) continue;
            key = itemStack;
            break;
        }
        NO_NEED_CONTROLLER_MB.put(key, (ControllerDefinition[])ArrayUtils.add((Object[])NO_NEED_CONTROLLER_MB.get(key), (Object)definition));
    }

    public static ControllerDefinition[] checkNoNeedController(ItemStack catalyst) {
        if (catalyst == null) {
            return new ControllerDefinition[0];
        }
        if (CATALYST_SET.contains(catalyst.func_77973_b())) {
            for (ItemStack itemStack : NO_NEED_CONTROLLER_MB.keySet()) {
                if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)catalyst) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)catalyst)) continue;
                return NO_NEED_CONTROLLER_MB.get(itemStack);
            }
        }
        return new ControllerDefinition[0];
    }

    public static <T extends ComponentDefinition> void registerComponentFromResource(Class<?> source, ResourceLocation location, Class<T> clazz, BiConsumer<T, JsonObject> postHandler) {
        try {
            InputStream inputstream = source.getResourceAsStream(String.format("/assets/%s/definition/%s.json", location.func_110624_b(), location.func_110623_a()));
            JsonObject config = FileUtility.jsonParser.parse((Reader)new InputStreamReader(inputstream)).getAsJsonObject();
            Constructor constructor = Arrays.stream(clazz.getDeclaredConstructors()).filter(c -> {
                if (c.getParameterCount() != 1) {
                    return false;
                }
                Class<?>[] classes = c.getParameterTypes();
                return ResourceLocation.class.isAssignableFrom(classes[0]);
            }).findFirst().orElseThrow(() -> new IllegalArgumentException("cant find the constructor with the parameters(resourcelocation)"));
            ComponentDefinition definition = (ComponentDefinition)constructor.newInstance(new ResourceLocation(config.get("location").getAsString()));
            definition.fromJson(config);
            MbdComponents.registerComponent(definition);
            if (postHandler != null) {
                handlers.add(() -> postHandler.accept(definition, config));
            }
        }
        catch (Exception e) {
            Multiblocked.LOGGER.error("error while loading the definition resource {}", (Object)location.toString());
        }
    }

    public static BlockInfo[] getBlockInfoWithCapability(MultiblockCapability<?> capability) {
        return (BlockInfo[])DEFINITION_REGISTRY.values().stream().filter(it -> it.traits.has(capability.name)).map(definition -> BlockInfo.fromBlockState(((BlockComponent)COMPONENT_BLOCKS_REGISTRY.get((Object)definition.location)).func_176223_P())).toArray(BlockInfo[]::new);
    }

    static {
        ComponentDefinition definition = new ComponentDefinition(new ResourceLocation("multiblocked", "dummy_component"), DummyComponentTileEntity.class);
        definition.properties.isOpaque = false;
        definition.properties.showInJei = false;
        MbdComponents.registerComponent(definition);
        DummyComponentBlock = (BlockComponent)COMPONENT_BLOCKS_REGISTRY.get((Object)definition.location);
        DummyComponentItem = (ItemComponent)((Object)COMPONENT_ITEMS_REGISTRY.get((Object)definition.location));
        DummyComponentBlock.func_149647_a(null);
        handlers = new ArrayList<Runnable>();
    }
}

