/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.registry;

import com.cleanroommc.multiblocked.api.block.BlockComponent;
import com.cleanroommc.multiblocked.api.block.CustomProperties;
import com.cleanroommc.multiblocked.api.capability.GuiOnlyCapability;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.definition.PartDefinition;
import com.cleanroommc.multiblocked.api.registry.MbdComponents;
import com.cleanroommc.multiblocked.common.capability.AspectThaumcraftCapability;
import com.cleanroommc.multiblocked.common.capability.AuraMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.EMCProjectECapability;
import com.cleanroommc.multiblocked.common.capability.EmberEmbersCapability;
import com.cleanroommc.multiblocked.common.capability.EnergyGTCECapability;
import com.cleanroommc.multiblocked.common.capability.EntityMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.FEMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.FluidMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.GPExtraUtilities2Capability;
import com.cleanroommc.multiblocked.common.capability.GasMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.HeatMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.HotAirProdigyCapability;
import com.cleanroommc.multiblocked.common.capability.ImpetusThaumicAugmentationCapability;
import com.cleanroommc.multiblocked.common.capability.ItemMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.LEMultiblockCapability;
import com.cleanroommc.multiblocked.common.capability.LPBloodMagicCapability;
import com.cleanroommc.multiblocked.common.capability.LaserMekanismCapability;
import com.cleanroommc.multiblocked.common.capability.ManaBotaniaCapability;
import com.cleanroommc.multiblocked.common.capability.MystMechPowerCapability;
import com.cleanroommc.multiblocked.common.capability.ParticleQMDCapability;
import com.cleanroommc.multiblocked.common.capability.PneumaticPressureCapability;
import com.cleanroommc.multiblocked.common.capability.StarlightAstralCapability;
import com.cleanroommc.multiblocked.common.capability.trait.FuelProgressTrait;
import com.cleanroommc.multiblocked.common.capability.trait.RecipeProgressTrait;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class MbdCapabilities {
    public static FEMultiblockCapability FE;
    public static ItemMultiblockCapability ITEM;
    public static FluidMultiblockCapability FLUID;
    public static final Map<String, MultiblockCapability<?>> CAPABILITY_REGISTRY;
    public static final Map<String, MultiblockCapability<?>> TRAIT_ONLY_CAPABILITY_REGISTRY;

    public static void registerCapability(MultiblockCapability<?> capability) {
        CAPABILITY_REGISTRY.put(capability.name, capability);
    }

    public static void registerTraitOnlyCapability(MultiblockCapability<?> capability) {
        if (capability.hasTrait()) {
            TRAIT_ONLY_CAPABILITY_REGISTRY.put(capability.name, capability);
        }
    }

    public static void registerCapabilities() {
        MbdCapabilities.registerTraitOnlyCapability(new GuiOnlyCapability("recipe_progress", RecipeProgressTrait::new));
        MbdCapabilities.registerTraitOnlyCapability(new GuiOnlyCapability("fuel_progress", FuelProgressTrait::new));
        FE = FEMultiblockCapability.CAP;
        MbdCapabilities.registerCapability(FE);
        ITEM = ItemMultiblockCapability.CAP;
        MbdCapabilities.registerCapability(ITEM);
        FLUID = FluidMultiblockCapability.CAP;
        MbdCapabilities.registerCapability(FLUID);
        MbdCapabilities.registerCapability(EntityMultiblockCapability.CAP);
        if (Loader.isModLoaded((String)"botania")) {
            MbdCapabilities.registerCapability(ManaBotaniaCapability.CAP);
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            MbdCapabilities.registerCapability(AspectThaumcraftCapability.CAP);
        }
        if (Loader.isModLoaded((String)"mekanism")) {
            MbdCapabilities.registerCapability(HeatMekanismCapability.CAP);
            MbdCapabilities.registerCapability(LaserMekanismCapability.CAP);
            MbdCapabilities.registerCapability(GasMekanismCapability.CAP);
        }
        if (Loader.isModLoaded((String)"qmd")) {
            MbdCapabilities.registerCapability(ParticleQMDCapability.CAP);
        }
        if (Loader.isModLoaded((String)"gregtech")) {
            MbdCapabilities.registerCapability(EnergyGTCECapability.CAP);
        }
        if (Loader.isModLoaded((String)"lightningcraft")) {
            MbdCapabilities.registerCapability(LEMultiblockCapability.CAP);
        }
        if (Loader.isModLoaded((String)"prodigytech")) {
            MbdCapabilities.registerCapability(HotAirProdigyCapability.CAP);
        }
        if (Loader.isModLoaded((String)"naturesaura")) {
            MbdCapabilities.registerCapability(AuraMultiblockCapability.CAP);
        }
        if (Loader.isModLoaded((String)"extrautils2")) {
            MbdCapabilities.registerCapability(GPExtraUtilities2Capability.CAP);
        }
        if (Loader.isModLoaded((String)"projecte")) {
            MbdCapabilities.registerCapability(EMCProjectECapability.CAP);
        }
        if (Loader.isModLoaded((String)"bloodmagic")) {
            MbdCapabilities.registerCapability(LPBloodMagicCapability.CAP);
        }
        if (Loader.isModLoaded((String)"embers")) {
            MbdCapabilities.registerCapability(EmberEmbersCapability.CAP);
        }
        if (Loader.isModLoaded((String)"thaumicaugmentation")) {
            MbdCapabilities.registerCapability(ImpetusThaumicAugmentationCapability.CAP);
        }
        if (Loader.isModLoaded((String)"pneumaticcraft")) {
            MbdCapabilities.registerCapability(PneumaticPressureCapability.CAP);
        }
        if (Loader.isModLoaded((String)"astralsorcery")) {
            MbdCapabilities.registerCapability(StarlightAstralCapability.CAP);
        }
        if (Loader.isModLoaded((String)"mysticalmechanics")) {
            MbdCapabilities.registerCapability(MystMechPowerCapability.CAP);
        }
    }

    public static MultiblockCapability<?> get(String s) {
        return CAPABILITY_REGISTRY.getOrDefault(s, TRAIT_ONLY_CAPABILITY_REGISTRY.get(s));
    }

    public static void registerAnyCapabilityBlocks() {
        for (MultiblockCapability<?> capability : CAPABILITY_REGISTRY.values()) {
            PartDefinition definition = new PartDefinition(new ResourceLocation("multiblocked", capability.name + ".any"));
            definition.properties.isOpaque = false;
            definition.properties.rotationState = CustomProperties.RotationState.NONE;
            definition.properties.showInJei = false;
            MbdComponents.registerComponent(definition);
            ((BlockComponent)MbdComponents.COMPONENT_BLOCKS_REGISTRY.get((Object)definition.location)).func_149647_a(null);
        }
    }

    public static Collection<MultiblockCapability<?>> getTraitCaps() {
        ArrayList result = new ArrayList(TRAIT_ONLY_CAPABILITY_REGISTRY.values());
        for (MultiblockCapability<?> cap : CAPABILITY_REGISTRY.values()) {
            if (!cap.hasTrait()) continue;
            result.add(cap);
        }
        return result;
    }

    static {
        CAPABILITY_REGISTRY = Maps.newHashMap();
        TRAIT_ONLY_CAPABILITY_REGISTRY = Maps.newHashMap();
    }
}

