/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.ICapabilityProxyHolder;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.MultiblockCapability;
import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeBuilder;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.cleanroommc.multiblocked.util.FileUtility;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenConstructor;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.recipe.RecipeMap")
@ZenRegister
public class RecipeMap {
    public static final RecipeMap EMPTY = new RecipeMap("empty");
    public static final Map<String, RecipeMap> RECIPE_MAP_REGISTRY = new HashMap<String, RecipeMap>();
    @ZenProperty
    public String name;
    @ZenProperty
    public List<Recipe> fuelRecipes;
    @ZenProperty
    public Set<MultiblockCapability<?>> inputCapabilities = new ObjectOpenHashSet();
    @ZenProperty
    public Set<MultiblockCapability<?>> outputCapabilities = new ObjectOpenHashSet();
    @ZenProperty
    public RecipeBuilder recipeBuilder = new RecipeBuilder(this);
    @ZenProperty
    public ResourceTexture progressTexture = new ResourceTexture("multiblocked:textures/gui/progress_bar_arrow.png");
    @ZenProperty
    public ResourceTexture fuelTexture = new ResourceTexture("multiblocked:textures/gui/progress_bar_fuel.png");
    @ZenProperty
    public IGuiTexture categoryTexture;
    public Map<String, Recipe> recipes = new HashMap<String, Recipe>();

    @ZenConstructor
    public RecipeMap(String name) {
        this.name = name;
    }

    public RecipeMap copy() {
        RecipeMap copy = new RecipeMap(this.name);
        copy.inputCapabilities.addAll(this.inputCapabilities);
        copy.outputCapabilities.addAll(this.outputCapabilities);
        copy.progressTexture = this.progressTexture;
        copy.fuelTexture = this.fuelTexture;
        copy.fuelRecipes = this.fuelRecipes == null ? null : new ArrayList<Recipe>(this.fuelRecipes);
        copy.categoryTexture = this.categoryTexture;
        copy.recipes.putAll(this.recipes);
        return copy;
    }

    @ZenMethod
    public static void register(RecipeMap recipeMap) {
        RECIPE_MAP_REGISTRY.put(recipeMap.name, recipeMap);
    }

    public static void registerRecipeFromFile(Gson gson, File location) {
        for (File file : Optional.ofNullable(location.listFiles((f, n) -> n.endsWith(".json"))).orElse(new File[0])) {
            try {
                JsonObject config = (JsonObject)FileUtility.loadJson(file);
                RecipeMap recipeMap = (RecipeMap)gson.fromJson((JsonElement)config, RecipeMap.class);
                if (recipeMap == null || recipeMap.name.equals("empty")) continue;
                RecipeMap.register(recipeMap);
            }
            catch (Exception e) {
                Multiblocked.LOGGER.error("error while loading the recipe map file {}", (Object)file.toString());
            }
        }
    }

    public String getUnlocalizedName() {
        return "multiblocked.recipe_map." + this.name;
    }

    @ZenMethod
    public RecipeBuilder start() {
        return this.recipeBuilder.copy();
    }

    public boolean hasCapability(IO io, MultiblockCapability<?> capability) {
        switch (io) {
            case IN: {
                return this.inputCapabilities.contains(capability);
            }
            case OUT: {
                return this.outputCapabilities.contains(capability);
            }
            case BOTH: {
                return this.inputCapabilities.contains(capability) && this.outputCapabilities.contains(capability);
            }
        }
        return false;
    }

    public void addRecipe(Recipe recipe) {
        this.recipes.put(recipe.uid, recipe);
        this.inputCapabilities.addAll((Collection<MultiblockCapability<?>>)recipe.inputs.keySet());
        this.inputCapabilities.addAll((Collection<MultiblockCapability<?>>)recipe.tickInputs.keySet());
        this.outputCapabilities.addAll((Collection<MultiblockCapability<?>>)recipe.outputs.keySet());
        this.outputCapabilities.addAll((Collection<MultiblockCapability<?>>)recipe.tickOutputs.keySet());
    }

    public void addFuelRecipe(Recipe recipe) {
        if (this.fuelRecipes == null) {
            this.fuelRecipes = new ArrayList<Recipe>();
        }
        this.fuelRecipes.add(recipe);
        this.inputCapabilities.addAll((Collection<MultiblockCapability<?>>)recipe.inputs.keySet());
    }

    @ZenMethod
    public List<Recipe> searchRecipe(ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (!holder.hasProxies()) {
            return Collections.emptyList();
        }
        ArrayList<Recipe> matches = new ArrayList<Recipe>();
        for (Recipe recipe : this.recipes.values()) {
            if (!recipe.matchRecipe(holder, logic) || !recipe.matchTickRecipe(holder, logic)) continue;
            matches.add(recipe);
        }
        return matches;
    }

    @ZenMethod
    public boolean isFuelRecipeMap() {
        return this.fuelRecipes != null && !this.fuelRecipes.isEmpty();
    }

    @ZenMethod
    public List<Recipe> searchFuelRecipe(ICapabilityProxyHolder holder, RecipeLogic logic) {
        if (!holder.hasProxies() || !this.isFuelRecipeMap()) {
            return Collections.emptyList();
        }
        ArrayList<Recipe> matches = new ArrayList<Recipe>();
        for (Recipe recipe : this.fuelRecipes) {
            if (!recipe.matchRecipe(holder, logic) || !recipe.matchTickRecipe(holder, logic)) continue;
            matches.add(recipe);
        }
        return matches;
    }

    @ZenMethod
    public Recipe getRecipe(String uid) {
        return this.recipes.get(uid);
    }

    @ZenMethod
    public List<Recipe> allRecipes() {
        return new ArrayList<Recipe>(this.recipes.values());
    }

    public void sort() {
        this.recipes = (Map)this.recipes.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, Object2ObjectLinkedOpenHashMap::new));
    }

    static {
        RecipeMap.register(EMPTY);
    }
}

