/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.cleanroommc.multiblocked.Multiblocked;
import com.cleanroommc.multiblocked.api.capability.IO;
import com.cleanroommc.multiblocked.api.capability.proxy.CapabilityProxy;
import com.cleanroommc.multiblocked.api.definition.ControllerDefinition;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.tile.ControllerTileEntity;
import com.cleanroommc.multiblocked.persistence.MultiblockWorldSavedData;
import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.multiblocked.recipe.RecipeLogic")
@ZenRegister
public class RecipeLogic {
    @ZenProperty
    public final ControllerTileEntity controller;
    public final ControllerDefinition definition;
    @ZenProperty
    public Recipe lastRecipe;
    @ZenProperty
    public List<Recipe> lastFailedMatches;
    @ZenProperty
    public int progress;
    @ZenProperty
    public int duration;
    @ZenProperty
    public int fuelTime;
    @ZenProperty
    public int fuelMaxTime;
    @ZenProperty
    public int timer;
    private Status status = Status.IDLE;
    private long lastPeriod;
    private final MultiblockWorldSavedData mbwsd;

    public RecipeLogic(ControllerTileEntity controller) {
        this.controller = controller;
        this.definition = (ControllerDefinition)controller.getDefinition();
        this.timer = Multiblocked.RNG.nextInt();
        this.lastPeriod = Long.MIN_VALUE;
        this.mbwsd = MultiblockWorldSavedData.getOrCreate(controller.func_145831_w());
    }

    @ZenMethod
    public boolean needFuel() {
        return ((ControllerDefinition)this.controller.getDefinition()).getRecipeMap().isFuelRecipeMap();
    }

    @ZenMethod
    public void update() {
        block9: {
            block7: {
                block8: {
                    ++this.timer;
                    if (this.getStatus() == Status.IDLE || this.lastRecipe == null) break block7;
                    if (this.getStatus() != Status.SUSPEND || this.timer % 5 != 0) break block8;
                    this.checkAsyncRecipeSearching(this::handleRecipeWorking);
                    break block9;
                }
                this.handleRecipeWorking();
                if (this.progress < this.duration) break block9;
                this.onRecipeFinish();
                break block9;
            }
            if (this.lastRecipe != null) {
                this.findAndHandleRecipe();
            } else if (this.timer % 5 == 0) {
                this.checkAsyncRecipeSearching(this::findAndHandleRecipe);
                if (this.lastFailedMatches != null) {
                    for (Recipe recipe : this.lastFailedMatches) {
                        if (recipe.checkConditions(this)) {
                            this.setupRecipe(recipe);
                        }
                        if (this.lastRecipe == null || this.getStatus() != Status.WORKING) continue;
                        this.lastFailedMatches = null;
                        break;
                    }
                }
            }
        }
        if (this.fuelTime > 0) {
            --this.fuelTime;
        }
    }

    @ZenMethod
    public void handleRecipeWorking() {
        if (this.lastRecipe.checkConditions(this) && this.handleFuelRecipe()) {
            this.setStatus(Status.WORKING);
            ++this.progress;
            this.handleTickRecipe(this.lastRecipe);
        } else {
            this.setStatus(Status.SUSPEND);
        }
        this.markDirty();
    }

    private void checkAsyncRecipeSearching(Runnable changed) {
        if (this.controller.asyncRecipeSearching) {
            if (this.mbwsd.getPeriodID() < this.lastPeriod) {
                this.lastPeriod = this.mbwsd.getPeriodID();
                changed.run();
            } else if (this.controller.hasProxies() && this.asyncChanged()) {
                changed.run();
            }
        } else {
            changed.run();
        }
    }

    @ZenMethod
    public boolean asyncChanged() {
        boolean needSearch = false;
        for (Long2ObjectOpenHashMap map : this.controller.getCapabilities().values()) {
            if (map != null) {
                for (CapabilityProxy proxy : map.values()) {
                    if (proxy == null || proxy.getLatestPeriodID() <= this.lastPeriod) continue;
                    this.lastPeriod = proxy.getLatestPeriodID();
                    needSearch = true;
                    break;
                }
            }
            if (!needSearch) continue;
            break;
        }
        return needSearch;
    }

    @ZenMethod
    public void findAndHandleRecipe() {
        this.lastFailedMatches = null;
        if (this.lastRecipe != null && this.lastRecipe.matchRecipe(this.controller, this) && this.lastRecipe.matchTickRecipe(this.controller, this) && this.lastRecipe.checkConditions(this)) {
            Recipe recipe = this.lastRecipe;
            this.lastRecipe = null;
            this.setupRecipe(recipe);
        } else {
            List<Recipe> matches = this.definition.getRecipeMap().searchRecipe(this.controller, this);
            this.lastRecipe = null;
            for (Recipe match : matches) {
                if (match.checkConditions(this)) {
                    this.setupRecipe(match);
                }
                if (this.lastRecipe != null && this.getStatus() == Status.WORKING) {
                    this.lastFailedMatches = null;
                    break;
                }
                if (this.lastFailedMatches == null) {
                    this.lastFailedMatches = new ArrayList<Recipe>();
                }
                this.lastFailedMatches.add(match);
            }
        }
    }

    @ZenMethod
    public boolean handleFuelRecipe() {
        if (!this.needFuel() || this.fuelTime > 0) {
            return true;
        }
        for (Recipe recipe : ((ControllerDefinition)this.controller.getDefinition()).getRecipeMap().searchFuelRecipe(this.controller, this)) {
            if (recipe.checkConditions(this) && recipe.handleRecipeIO(IO.IN, this.controller, this)) {
                this.fuelTime = this.fuelMaxTime = recipe.duration;
                this.markDirty();
            }
            if (this.fuelTime <= 0) continue;
            return true;
        }
        return false;
    }

    @ZenMethod
    public void handleTickRecipe(Recipe recipe) {
        if (recipe.hasTick()) {
            if (recipe.matchTickRecipe(this.controller, this)) {
                recipe.handleTickRecipeIO(IO.IN, this.controller, this);
                recipe.handleTickRecipeIO(IO.OUT, this.controller, this);
                this.setStatus(Status.WORKING);
            } else {
                --this.progress;
                this.setStatus(Status.SUSPEND);
            }
        }
    }

    @ZenMethod
    public void setupRecipe(Recipe recipe) {
        if (this.definition.setupRecipe != null) {
            try {
                if (this.definition.setupRecipe.apply(this, recipe)) {
                    return;
                }
            }
            catch (Exception exception) {
                this.definition.setupRecipe = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)this.definition.location, (Object)"setupRecipe", (Object)exception);
            }
        }
        if (this.handleFuelRecipe() && recipe.handleRecipeIO(IO.IN, this.controller, this)) {
            this.lastRecipe = recipe;
            this.setStatus(Status.WORKING);
            this.progress = 0;
            this.duration = this.definition.calcRecipeDuration == null ? recipe.duration : this.definition.calcRecipeDuration.apply(this, recipe, recipe.duration);
            this.markDirty();
        }
    }

    @ZenMethod
    public void setStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            this.controller.setStatus(status.name);
        }
    }

    @ZenMethod
    public Status getStatus() {
        return this.status;
    }

    @ZenMethod
    @ZenGetter
    public boolean isWorking() {
        return this.status == Status.WORKING;
    }

    @ZenMethod
    @ZenGetter
    public boolean isIdle() {
        return this.status == Status.IDLE;
    }

    @ZenMethod
    @ZenGetter
    public boolean isSuspend() {
        return this.status == Status.SUSPEND;
    }

    @ZenMethod
    public void onRecipeFinish() {
        if (this.definition.recipeFinish != null) {
            try {
                if (this.definition.recipeFinish.apply(this, this.lastRecipe)) {
                    return;
                }
            }
            catch (Exception exception) {
                this.definition.recipeFinish = null;
                Multiblocked.LOGGER.error("definition {} custom logic {} error", (Object)this.definition.location, (Object)"recipeFinish", (Object)exception);
            }
        }
        this.lastRecipe.handleRecipeIO(IO.OUT, this.controller, this);
        if (this.lastRecipe.matchRecipe(this.controller, this) && this.lastRecipe.matchTickRecipe(this.controller, this) && this.lastRecipe.checkConditions(this)) {
            this.setupRecipe(this.lastRecipe);
        } else {
            this.setStatus(Status.IDLE);
            this.progress = 0;
            this.duration = 0;
            this.markDirty();
        }
    }

    @ZenMethod
    public void markDirty() {
        this.controller.markAsDirty();
    }

    public void readFromNBT(NBTTagCompound compound) {
        Recipe recipe = this.lastRecipe = compound.func_74764_b("recipe") ? this.definition.getRecipeMap().recipes.get(compound.func_74779_i("recipe")) : null;
        if (this.lastRecipe != null) {
            this.status = compound.func_74764_b("status") ? Status.values()[compound.func_74762_e("status")] : Status.WORKING;
            this.duration = compound.func_74764_b("duration") ? compound.func_74762_e("duration") : this.lastRecipe.duration;
            this.progress = compound.func_74764_b("progress") ? compound.func_74762_e("progress") : 0;
            this.fuelTime = compound.func_74764_b("fuelTime") ? compound.func_74762_e("fuelTime") : 0;
            this.fuelMaxTime = compound.func_74764_b("fuelMaxTime") ? compound.func_74762_e("fuelMaxTime") : this.fuelTime;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.lastRecipe != null && this.status != Status.IDLE) {
            compound.func_74778_a("recipe", this.lastRecipe.uid);
            compound.func_74768_a("status", this.status.ordinal());
            compound.func_74768_a("progress", this.progress);
            compound.func_74768_a("duration", this.duration);
            compound.func_74768_a("fuelTime", this.fuelTime);
            compound.func_74768_a("fuelMaxTime", this.fuelMaxTime);
        }
        return compound;
    }

    @ZenClass(value="mods.multiblocked.recipe.Status")
    @ZenRegister
    public static enum Status {
        IDLE("idle"),
        WORKING("working"),
        SUSPEND("suspend");

        @ZenProperty
        public final String name;

        private Status(String name) {
            this.name = name;
        }
    }
}

