/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.multiblocked.api.recipe;

import com.cleanroommc.multiblocked.api.gui.texture.IGuiTexture;
import com.cleanroommc.multiblocked.api.gui.texture.ResourceTexture;
import com.cleanroommc.multiblocked.api.gui.widget.WidgetGroup;
import com.cleanroommc.multiblocked.api.gui.widget.imp.LabelWidget;
import com.cleanroommc.multiblocked.api.gui.widget.imp.SwitchWidget;
import com.cleanroommc.multiblocked.api.recipe.Recipe;
import com.cleanroommc.multiblocked.api.recipe.RecipeLogic;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RecipeCondition {
    protected boolean isReverse;

    public abstract String getType();

    public String getTranlationKey() {
        return "multiblocked.recipe.condition." + this.getType();
    }

    public IGuiTexture getInValidTexture() {
        return new ResourceTexture("multiblocked:textures/gui/condition_" + this.getType() + ".png").getSubTexture(0.0, 0.0, 1.0, 0.5);
    }

    public IGuiTexture getValidTexture() {
        return new ResourceTexture("multiblocked:textures/gui/condition_" + this.getType() + ".png").getSubTexture(0.0, 0.5, 1.0, 0.5);
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public boolean isOr() {
        return false;
    }

    public RecipeCondition setReverse(boolean reverse) {
        this.isReverse = reverse;
        return this;
    }

    public abstract ITextComponent getTooltips();

    public abstract boolean test(@Nonnull Recipe var1, @Nonnull RecipeLogic var2);

    public abstract RecipeCondition createTemplate();

    @Nonnull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        if (this.isReverse) {
            jsonObject.addProperty("reverse", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        this.isReverse = JsonUtils.func_151209_a((JsonObject)config, (String)"reverse", (boolean)false);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void openConfigurator(WidgetGroup group) {
        group.addWidget(new SwitchWidget(0, 0, 15, 15, (cd, r) -> {
            this.isReverse = r;
        }).setBaseTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.0, 1.0, 0.5)).setPressedTexture(new ResourceTexture("multiblocked:textures/gui/boolean.png").getSubTexture(0.0, 0.5, 1.0, 0.5)).setHoverBorderTexture(1, -1).setPressed(this.isReverse).setHoverTooltip("multiblocked.gui.condition.reverse"));
        group.addWidget(new LabelWidget(20, 3, "multiblocked.gui.condition.reverse.label").setTextColor(-1).setDrop(true));
    }
}

